(*********************************************************************)
(* UCalcSpvSMOPolyKernel.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(11/04/2005)

Copie de la classe PolyKernel de WEKA, ver. 3-4
}

unit UCalcSpvSMOPolyKernel;

interface

USES
   UDatasetExamples,
   UCalcSpvSVMBinarySMO,
   UCompSpvLDefinition;

TYPE
 TPolyKernel = class(TKernel)
 private
 //** The size of the cache (a prime number) -- private int m_cacheSize;
 m_cacheSize : integer;
 //** Use lower-order terms? -- private boolean m_lowerOrder = false;
 m_lowerOrder: boolean;
 //** The exponent for the polynomial kernel. -- private double m_exponent = 1.0;
 m_exponent: double;
 //** Kernel cache - private double[] m_storage; private long[] m_keys;
 m_storage: array of double;
 m_keys: array of integer;
 //** Counts the number of kernel evaluations. -- private int m_kernelEvals = 0;
 m_kernelEvals: integer;
 //** The number of instance in the dataset -- private int m_numInsts;
 m_numInsts: integer;
 //private double dotProd(Instance inst1, Instance inst2)
 function dotProd(inst1, inst2: integer): double;
 public
 //public PolyKernel(Instances dataset, int cacheSize, double exponent, boolean lowerOrder)
 constructor create(operator: TBinarySMO; instances: TExamples; cacheSize: integer; exponent: double; lowerOrder: boolean);
 //les mthodes standard  surcharger...
 function eval(id1, id2: integer; inst1: integer): double; override;
 procedure clean(); override;
 function numEvals(): integer; override;
 end;

 TNormalizedPolyKernel = class(TPolyKernel)
                         public
                         function eval(id1, id2: integer; inst1: integer): double; override;  
                         end;  

implementation

USES
   Sysutils,
   Math;

{ TPolyKernel }

procedure TPolyKernel.clean;
begin
 setLength(m_storage,0);
 setLength(m_keys,0);
end;

constructor TPolyKernel.create(operator: TBinarySMO; instances: TExamples; cacheSize: integer;
  exponent: double; lowerOrder: boolean);
begin
 inherited create(operator);
 //init.
 m_exponent:= exponent;
 m_lowerOrder:= lowerOrder;
 m_data:= instances;
 m_numInsts:= m_data.Size;
 m_cacheSize:= cacheSize;
 setLength(m_storage,m_cacheSize);
 setLength(m_keys,m_cacheSize);
 //autre init.
 m_kernelEvals:= 0;
end;

function TPolyKernel.dotProd(inst1, inst2: integer): double;
var somme: double;
    //p1, p2: integer;
    j: integer;
begin
 //formule maison -- autrement plus puissant -- DOTPROD :: produit scalaire
 somme:= 0.0;
 for j:= 0 to pred(FOperator.Descriptors.Count) do
  //somme:= somme+m_operator.Descriptors.Attribute[j].cValue[inst1]*m_operator.Descriptors.Attribute[j].cValue[inst2];
  somme:= somme+FOperator.attTransSVM.cValue[j,inst1]*FOperator.attTransSVM.cValue[j,inst2];
 //and then...
 result:= somme;
end;

function TPolyKernel.eval(id1, id2: integer; inst1: integer): double;
var resultat: double;
    key: longint;
    location: integer;
begin
 //resultat:= 0.0;
 key:= -1;
 location:= -1;

 // we can only cache if we know the indexes
 if (id1 >= 0) and (m_keys <> nil)
  then
   begin
    //
    if (id1 > id2)
     then key:= id1*m_numInsts + id2
     else key:= id2*m_numInsts + id1;
    //
    if (key < 0)
     then raise Exception.Create('cache overflow in eval() of PolyKernel');
    //
    location:= key mod length(m_keys);
    if (m_keys[location] = (key + 1))
     then
      begin
       result:= m_storage[location];
       EXIT;
      end;
   end;

 //
 if (id1 = id2)
  then resultat:= dotProd(inst1,inst1)
  else resultat:= dotProd(inst1,m_data.Number[succ(id2)]);

 // Use lower order terms?
 if (m_lowerOrder)
  then resultat:= resultat+1.0;

 //
 if (m_exponent <> 1.0)
  then resultat:= Math.Power(resultat,m_exponent);

 //
 inc(m_kernelEvals);

 //
 if (key <> -1)
  then
   begin
    m_storage[location]:= resultat;
    m_keys[location]:= key + 1;
   end;

 //
 result:= resultat;

end;

function TPolyKernel.numEvals: integer;
begin
 result:= m_kernelEvals;
end;

{ TNormalizedPolyKernel }

function TNormalizedPolyKernel.eval(id1, id2, inst1: integer): double;
var division: double;
begin
 division:= SQRT(inherited eval(id1,id1,inst1) * inherited eval(id2,id2,m_data.Number[succ(id2)]));
 
 if (division <> 0.0)
  then result:= inherited eval(id1,id2,inst1) / division
  else result:= 0.0;
  
 (*
     double div = Math.sqrt(super.eval(id1, id1, inst1) * super.eval(id2, id2, m_data.instance(id2)));
    if(div != 0)
    {
      return super.eval(id1, id2, inst1) / div;
    } 
    else 
    {
      return 0;
    }
 *)
end;

end.
