(*********************************************************************)
(* UCalcSpvSMOPolyKernel.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(15/04/2005)

Copie de la classe RBFKernel.java de WEKA, ver. 3-4
}

unit UCalcSpvSMORbfKernel;

interface

USES
   UDatasetExamples,
   UCalcSpvSVMBinarySMO,
   UCompSpvLDefinition;

TYPE
  TRBFKernel = class(TKernel)
  private
  //** The precalculated dotproducts of <inst_i,inst_i> --  private double m_kernelPrecalc[];
  m_kernelPrecalc: array of double;
  //** Counts the number of kernel evaluations. -- private int m_kernelEvals = 0;
  m_kernelEvals: integer;
  //** The size of the cache (a prime number) -- private int m_cacheSize;
  m_cacheSize: integer;
  //** Kernel cache -- private double[] m_storage; private long[] m_keys;
  m_storage: array of double;
  m_keys: array of longint;
  //** Gamma for the RBF kernel. -- private double m_gamma = 0.01;
  m_gamma: double;
  //** The number of instance in the dataset -- private int m_numInsts;
  m_numInsts: integer;
  //OK out
  //okOut: boolean;
  //private double dotProd(Instance inst1, Instance inst2)
  function dotProd(inst1, inst2: integer): double;
  public
  //public RBFKernel(Instances data, int cacheSize, double gamma)
  constructor create(operator: TBinarySMO; instances: TExamples; cacheSize: integer; gamma: double);
  //les mthodes standard  surcharger...
  function eval(id1, id2: integer; inst1: integer): double; override;
  procedure clean(); override;
  function numEvals(): integer; override;
  end;

implementation

USES
   Classes, Sysutils, ULogFile;

{ TRBFKernel }

procedure TRBFKernel.clean;
begin
 m_storage:= nil;
 m_keys:= nil;

 //okOut:= false;
end;

constructor TRBFKernel.create(operator: TBinarySMO; instances: TExamples;
  cacheSize: integer; gamma: double);
var i: integer;
begin
 inherited create(operator);
 //init.
 m_gamma:= gamma;
 m_data:= instances;
 m_numInsts:= m_data.Size;
 m_cacheSize:= cacheSize;
 setLength(m_storage,m_cacheSize);
 setLength(m_keys,m_cacheSize);
 //autre init.
 m_kernelEvals:= 0;
 //debug...
 //okOut:= true;
 //pr-calcul
 setLength(m_kernelPrecalc,m_data.Size);
 for i:= 0 to pred(m_data.Size) do
  m_kernelPreCalc[i]:= dotProd(m_data.Number[succ(i)],m_data.Number[succ(i)]);

 (* --> source JAVA - WEKA
     m_gamma = gamma;
    m_data = data;
    m_numInsts = m_data.numInstances();
    m_cacheSize = cacheSize;
    m_storage = new double[m_cacheSize];
    m_keys = new long[m_cacheSize];

    m_kernelPrecalc=new double[data.numInstances()];

    for(int i=0;i<data.numInstances();i++)
      m_kernelPrecalc[i]=dotProd(data.instance(i),data.instance(i));
 *)
end;

function TRBFKernel.dotProd(inst1, inst2: integer): double;
var somme: double;
    j: integer;
begin
 //formule maison -- autrement plus puissant -- DOTPROD :: produit scalaire
 somme:= 0.0;
 for j:= 0 to pred(FOperator.Descriptors.Count) do
  somme:= somme+FOperator.attTransSVM.cValue[j,inst1]*FOperator.attTransSVM.cValue[j,inst2];
 //and then...
 result:= somme;
end;

(*
  public double eval(int id1, int id2, Instance inst1) 
    throws Exception {
  
    double result = 0;
    long key = -1;
    int location = -1;
      
    // we can only cache if we know the indexes
    if (id1 >= 0) {
      if (id1 > id2) {
	key = (long)id1 * m_numInsts + id2;
      } else {
	key = (long)id2 * m_numInsts + id1;
      }
      if (key < 0) {
	throw new Exception("Cache overflow detected!");
      }
      location = (int)(key % m_keys.length);
      if (m_keys[location] == (key + 1)) {
	return m_storage[location];
      }
    }
	
    Instance inst2 = m_data.instance(id2);

    double precalc1;

    if(id1 == -1)
      precalc1 = dotProd(inst1,inst1);
    else
      precalc1 = m_kernelPrecalc[id1];
	
    result = Math.exp(m_gamma * (2. * dotProd(inst1, inst2) -
				 precalc1 - m_kernelPrecalc[id2]));
  
    m_kernelEvals++;
    
    // store result in cache
    if (key != -1){
      m_storage[location] = result;
      m_keys[location] = (key + 1);
    }

    return result;
  }
*)

function TRBFKernel.eval(id1, id2, inst1: integer): double;
var sortie: double;
    key: longint;
    location: integer;
    inst2: integer;
    precalc1: double;
begin
    //result := 0;
    key := -1;
    location := -1;

    // we can only cache if we know the indexes
    if (id1 >= 0)
    then
    begin
      //
      if (id1 > id2)
      then
      begin
	    key := id1 * m_numInsts + id2;
      end
      else
      begin
	    key := id2 * m_numInsts + id1;
      end;
      //
      if (key < 0)
      then
      begin
	    //throw new Exception("Cache overflow detected!");
       raise Exception.Create('Cache overflow detected!');
      end;
      
      location := (key mod length(m_keys));

      if (m_keys[location] = (key + 1))
      then
      begin
	    result:= m_storage[location];
       EXIT;
      end;
    end;

    inst2 := m_data.Number[succ(id2)];

    //double precalc1;

    if(id1 = -1)
      then precalc1 := dotProd(inst1,inst1)
      else precalc1 := m_kernelPrecalc[id1];

    sortie := EXP(m_gamma * (2. * dotProd(inst1, inst2) - precalc1 - m_kernelPrecalc[id2]));

    inc(m_kernelEvals);

    // store result in cache
    if (key <> -1)
    then
     begin
      m_storage[location] := sortie;
      m_keys[location] := (key + 1);
     end;

     (*
    if (okOut)
     then TraceLog.WriteToLogFile(format('%d:%d = %.6f',[id1,id2,sortie]));
    *)

    result := sortie;

end;

function TRBFKernel.numEvals: integer;
begin
 result:= m_kernelEvals;
end;

end.
