(**************************************************************)
(* UCalcSpvSMOSet.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(11/04/2005)

Copie de la classe SMOSet de WEKA, ver. 3-4
}

unit UCalcSpvSMOSet;

interface

TYPE
  TSMOSet = class
  private
  //** The current number of elements in the set --  private int m_number;
  m_number : integer;
  //** The first element in the set -- private int m_first;
  m_first: integer;
  //** Indicators -- private boolean[] m_indicators;
  m_indicators: array of boolean;
  //** The next element for each element -- private int[] m_next;
  m_next: array of integer;
  //** The previous element for each element -- private int[] m_previous;
  m_previous: array of integer;
  public
  //public SMOset(int size)
  constructor create(size: integer);
  //public boolean contains(int index)
  function contains(index: integer): boolean;
  //public void delete(int index)
  procedure delete(index: integer);
  //public void insert(int index)
  procedure insert(index: integer);
  //public int getNext(int index)
  function  getNext(index: integer): integer;
  //public int numElements()
  function  numElements(): integer;
  end;

implementation

{ TSMOSet }

function TSMOSet.contains(index: integer): boolean;
begin
 result:= m_indicators[index];
end;

constructor TSMOSet.create(size: integer);
begin
 inherited Create();
 //tableaux
 setLength(m_indicators,size);
 setLength(m_next,size);
 setLength(m_previous,size);
 //indices
 m_number:= 0;
 m_first:= -1;
end;

procedure TSMOSet.delete(index: integer);
begin
 if m_indicators[index]
  then
   begin
    //
    if (m_first = index)
     then m_first:= m_next[index]
     else m_next[m_previous[index]]:= m_next[index];
    //
    if (m_next[index]<>-1)
     then m_previous[m_next[index]]:= m_previous[index];
    //
    m_indicators[index]:= false;
    dec(m_number);
   end;
end;

function TSMOSet.getNext(index: integer): integer;
begin
 if (index = -1)
  then result:= m_first
  else result:= m_next[index];
end;

procedure TSMOSet.insert(index: integer);
begin
 if not(m_indicators[index])
  then
   begin
    //
    if (m_number = 0)
     then
      begin
       m_first:= index;
       m_next[index]:= -1;
       m_previous[index]:= -1;
      end
     else
      begin
       m_previous[m_first]:= index;
       m_next[index]:= m_first;
       m_previous[index]:= -1;
       m_first:= index;
      end;
    //
    m_indicators[index]:= true;
    inc(m_number);
   end;
end;

function TSMOSet.numElements: integer;
begin
 result:= m_number;
end;

end.
