(********************************************************************)
(* UCalcSpvSVMBinarySMO.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(11/04/2005)

Copie de la classe BinarySMO de WEKA, ver. 3-4
}

unit UCalcSpvSVMBinarySMO;

interface

USES
   UDatasetExamples,
   UCalcSpvSMOSet,
   UCompSpvLDefinition,
   UDatasetDefinition,
   UCalcDistribution,
   UCalcSpvSMOAttTransformation,
   UCalcSpvStructScore;

TYPE

   //dclaration forward
   TBinarySMO = class;

   //structure de base d'un Kernel
   TKernel = class
             public
             //l'oprateur -- pour l'accs aux donnes -- adaptation TANAGRA
             FOperator: TBinarySMO;
             //** The dataset -- Instances m_data;
             m_data: TExamples;
             (**
               * Computes the result of the kernel function for two instances.
               * If id1 == -1, eval use inst1 instead of an instance in the dataset.
               *
               * @param id1 the index of the first instance in the dataset
               * @param id2 the index of the second instance in the dataset
               * @param inst the instance corresponding to id1 (used if id1 == -1)
               * @return the result of the kernel function
               */
              public abstract double eval(int id1, int id2, Instance inst1)
                throws Exception;*)
             function eval(id1, id2: integer; inst: integer): double; virtual; abstract;
             (**
               * Frees the memory used by the kernel.
               * (Usefull with kernels which use cache.)
               * This function is called when the training is done.
               * i.e. after that, eval will be called with id1 == -1.
               */
              public abstract void clean();*)
             procedure clean(); virtual; abstract;
             (**
             * Returns the number of kernel evaluation performed.
             *
             * @return the number of kernel evaluation performed.
             */
             public abstract int numEvals();*)
             function numEvals(): integer; virtual; abstract;
             //constructor -- on passe les donnes
             constructor create(operator: TBinarySMO);
             end;



  //classe de calcul SMO
  TBinarySMO = class(TCalcSpvLearning)
  private

  //*****************************************
  //**** les miens
  //*****************************************

  //mthode de transformation des variables
  FAttTransSVM: TAttTrans;

  //*****************************************
  //**** en provenance de SMO
  //*****************************************

  //** The exponent for the polynomial kernel. -- private double m_exponent = 1.0;
  m_exponent: double;
  //** Use lower-order terms? -- private boolean m_lowerOrder = false;
  m_lowerOrder: boolean;
  //** Gamma for the RBF kernel. -- private double m_gamma = 0.01;
  m_gamma: double;
  //** The complexity parameter. -- private double m_C = 1.0;
  m_C: double;
  //** Epsilon for rounding. -- private double m_eps = 1.0e-12;
  m_eps: double;
  //** Tolerance for accuracy of result. -- private double m_tol = 1.0e-3;
  m_tol: double;
  //** Whether to normalize/standardize/neither */
  //private int m_filterType = FILTER_NORMALIZE;
  m_filterType: TEnumAttTransformSVM;
  //** Feature-space normalization? */
  //private boolean m_featureSpaceNormalization = false;
  m_featureSpaceNormalization: boolean;
  //** Use RBF kernel? (default: poly) -- private boolean m_useRBF = false;
  m_useRBF: boolean;
  //** The size of the cache (a prime number) -- private int m_cacheSize = 1000003;
  m_cacheSize: integer;
  //** Only numeric attributes in the dataset? -- private boolean m_onlyNumeric;
  m_onlyNumeric: boolean;
  //** Precision constant for updating sets -- private static double m_Del = 1000 * Double.MIN_VALUE;
  m_Del: double;
  //** The random number seed  -- private int m_randomSeed = 1;
  m_randomSeed: integer;
  
  //**************************************************
  //**** en provenance de BinarySMO
  //**************************************************

  // The Lagrange multipliers. -- private double[] m_alpha;
  m_alpha: array of double;
  //** The thresholds -- private double m_b, m_bLow, m_bUp;
  m_b, m_bLow, m_bUp: double;
  //** The indices for m_bLow and m_bUp -- private int m_iLow, m_iUp;
  m_iLow, m_iUp : integer;
  //** The training data. -- private Instances m_data;
  m_data: TExamples;
  //** Weight vector for linear machine. -- private double[] m_weights;
  m_weights: array of double;
  //** Kernel to use -- private Kernel m_kernel;
  m_Kernel: TKernel;
  //** The transformed class values. -- private double[] m_class;
  m_class: array of double;
  //** The current set of errors for all non-bound examples. -- private double[] m_errors;
  m_errors: array of double;
  //** The five different sets used by the algorithm. */
  m_I0: TSMOset; // {i: 0 < m_alpha[i] < C}
  m_I1: TSMOset; // {i: m_class[i] = 1, m_alpha[i] = 0}
  m_I2: TSMOset; // {i: m_class[i] = -1, m_alpha[i] =C}
  m_I3: TSMOset; // {i: m_class[i] = 1, m_alpha[i] = C}
  m_I4: TSMOset; // {i: m_class[i] = -1, m_alpha[i] = 0}
  //** The set of support vectors */
  m_supportVectors: TSMOSet; // {i: 0 < m_alpha[i]}
  //** Stores logistic regression model for probability estimate */
  //private Logistic m_logistic = null;
  //** Stores the weight of the training instances -- private double m_sumOfWeights = 0;
  m_sumOfWeights: double;
  (**
   * Computes SVM output for given instance.
   *
   * @param index the instance for which output is to be computed
   * @param inst the instance
   * @return the output of the SVM for the given instance
   */
  private double SVMOutput(int index, Instance inst)*)
  function  SVMOutput(index: integer; inst: integer): double;
  //private boolean examineExample(int i2)
  function  examineExample(i2: integer): boolean;
  //private boolean takeStep(int i1, int i2, double F2)
  function  takeStep(i1,i2: integer; F2: double): boolean;
  //private void buildClassifier(Instances insts...
  procedure buildClassifier();
  //private,  prparer au cas o il faut insrer qq chose au milieu
  procedure runClassifier(examples: TExamples);
  //mettre les paramtres par dfaut de WEKA
  procedure setDefaultWEKAParameters();
  //rcuprer les paramtres spcifis par l'utilisateur dans TANAGRA
  procedure getTANAGRAParameters();
  //calculs internes
  procedure computeInternalStatistics();
  protected
  procedure   destroyStructures(); override;
  public
  //surcharge normale dans la hirachie
  function    coreLearning(examples: TExamples): boolean; override;
  //prospective totale -- utiliser une fonction logistique sur la sortie
  procedure   getScore(example: integer; var postProba: TTabScore); override;
  //comparer au seuil 0 (si output <= 0 alors c = 1 sinon c = 2
  procedure   classification(example: integer; var response: TTypeDiscrete); override;
  //description des rsultats
  function    getHTMLResults(): string; override;
  //accs aux donnes
  property    attTransSVM: TAttTrans read FAttTransSVM;
  end;

implementation

USES
   SysUtils, Math, UCalcSpvSMOPolyKernel, ULogFile, UConstConfiguration,
   UCompSpvSVM, UCalcSpvSMORbfKernel, UCalcRndGenerator;

{$DEFINE SMO_OWNER_M_DATA}

{ TBinarySMO }

procedure TBinarySMO.runClassifier(examples: TExamples);
begin
 //mettre les paramtres par dfaut de WEKA
 self.setDefaultWEKAParameters();

 //rcuprer les paramtres en provenance de l'oprateur
 self.getTANAGRAParameters();

 //rcuprer les donnes pour l'apprentissage -- recopie avec mlange ou branchement direct ?

 {$IFDEF SMO_OWNER_M_DATA}
 if assigned(m_data) then m_data.Free();
 m_data:= examples.funcRandomizeExamples(seedStandard);
 {$ELSE}
 m_data:= examples;
 {$ENDIF}

 //prparer les calculs intermdiaires
 computeInternalStatistics();

 //lancer l'apprentissage
 // voir plus tard si on veut largir par exemple avec le multi-classes
 //on reste trs basique pour l'instant avec un appel direct
 self.buildClassifier();
 
end;

function TBinarySMO.examineExample(i2: integer): boolean;
var y2, F2: double;
    i1: integer;
    optimal: boolean;
begin
 i1:= -1;

 y2:= m_class[i2];
 //alph2:= m_alpha[i2];

 if m_I0.contains(i2)
  then F2:= m_errors[i2]
  else
   begin
   
    F2:= self.SVMOutput(i2,m_data.Number[succ(i2)]) + m_b - y2;

    (*
    if (i2 = 0)
     then TraceLog.WriteToLogFile(format('i2 = %d, F2 = %.4f (m_b = %.4f)',[i2,F2,m_b]));
    *)

    m_errors[i2]:= F2;
    
    //Update thresholds
    if ((m_I1.contains(i2) OR m_I2.contains(i2)) AND (F2 < m_bUp))
     then
      begin
       m_bUp:= F2;
       m_iUp:= i2;
      end
     else
      begin
       if ((m_I3.contains(i2) OR m_I4.contains(i2)) AND (F2 > m_bLow))
        then
         begin
          m_bLow:= F2;
          m_iLow:= i2;
         end;
      end;
   end;
   
  //Check optimality using current bLow and bUp and, if
  optimal:= true;

  if (m_I0.contains(i2) OR m_I1.contains(i2) OR m_I2.contains(i2))
   then
    begin
     if (m_bLow - F2 > 2 * m_tol)
      then
       begin
        optimal:= false;
        i1:= m_iLow;
       end;
    end;

  if (m_I0.contains(i2) OR m_I3.contains(i2) OR m_I4.contains(i2))
   then
    begin
     if (F2 - m_bUp > 2 * m_tol)
     then
     begin
         optimal := false; i1 := m_iUp;
     end;
    end;
    
  //
  if optimal
   then
    begin
     result:= false;
     EXIT;
    end;
  //For i2 unbound choose the better i1...
  if m_I0.contains(i2)
   then
    begin
     if (m_bLow - F2 > F2 - m_bUp)
      then i1:= m_iLow
      else i1:= m_iUp;
    end;

  //
  if (i1 = -1)
   then Raise Exception.Create('This should never happen -- TBinarySMO.ExamineExample')
   else result:= takeStep(i1,i2,F2);

end;

function TBinarySMO.SVMOutput(index: integer; inst: integer): double;
var sortie: double;
    p: integer;
    i: integer;
begin
 sortie:= 0.0;
 //
 if not(m_useRBF) and (m_exponent = 1.0)
  then
   begin
    for p:= 0 to pred(self.Descriptors.Count) do
     //sortie:= sortie+m_weights[p]*self.Descriptors.Attribute[p].cValue[inst];
     sortie:= sortie+m_weights[p]*self.FAttTransSVM.cValue[p,inst];
   end
  else
   begin
    i:= m_supportVectors.getNext(-1);
    while (i<>-1) do
     begin
      sortie:= sortie+m_class[i]*m_alpha[i]*m_kernel.eval(index,i,inst);
      i:= m_supportVectors.getNext(i);
     end;
   end;
 //
 sortie:= sortie-m_b;
 //
 result:= sortie;
end;

function TBinarySMO.takeStep(i1, i2: integer; F2: double): boolean;
var alph1, alph2, y1, y2, F1, s, L, H, k11, k12, k22, eta, a1, a2, p_f1, p_f2, v1, v2, Lobj, Hobj, b1, b2, bOld : double;
    C1,C2: double;
    gamma: double;
    inst1,inst2: integer;
    p1, p2: integer;
    j: integer;
begin
      //C1 = m_C * m_data.instance(i1).weight();
      //C2 = m_C * m_data.instance(i2).weight();

      C1:= 1.0;
      C2:= 1.0;

      // Don't do anything if the two instances are the same
      if (i1 = i2)
       then
        begin
         result:= FALSE;
         EXIT;
        end;

      // Initialize variables
      alph1 := m_alpha[i1]; alph2 := m_alpha[i2];
      y1 := m_class[i1]; y2 := m_class[i2];
      F1 := m_errors[i1];
      s := y1 * y2;

      // Find the constraints on a2
      if (y1 <> y2)
      then
       begin
		L := Math.max(0, alph2 - alph1);
		H := Math.min(C2, C1 + alph2 - alph1);
       end
      else
       begin
		L := Math.max(0, alph1 + alph2 - C1);
		H := Math.min(C2, alph1 + alph2);
       end;

      if (L >= H)
      then
       begin
		result:=false;
       EXIT;
       end;

      // Compute second derivative of objective function
      k11 := m_kernel.eval(i1, i1, m_data.Number[succ(i1)]);
      k12 := m_kernel.eval(i1, i2, m_data.Number[succ(i1)]);
      k22 := m_kernel.eval(i2, i2, m_data.Number[succ(i2)]);
      eta := 2 * k12 - k11 - k22;

      // Check if second derivative is negative
      if (eta < 0) 
      then

      begin
		// Compute unconstrained maximum
		a2 := alph2 - y2 * (F1 - F2) / eta;
		// Compute constrained maximum
		if (a2 < L)
		then
       begin
	  		a2 := L;
		end
		else
		if (a2 > H)
		then
       begin
	  		a2 := H;
		end;
      end

      else
      
      begin

		// Look at endpoints of diagonal
		p_f1 := SVMOutput(i1, m_data.Number[succ(i1)]);
		p_f2 := SVMOutput(i2, m_data.Number[succ(i2)]);
       
		v1 := p_f1 + m_b - y1 * alph1 * k11 - y2 * alph2 * k12;
		v2 := p_f2 + m_b - y1 * alph1 * k12 - y2 * alph2 * k22;

		gamma := alph1 + s * alph2;
		Lobj := (gamma - s * L) + L - 0.5 * k11 * (gamma - s * L) * (gamma - s * L) - 0.5 * k22 * L * L - s * k12 * (gamma - s * L) * L - y1 * (gamma - s * L) * v1 - y2 * L * v2;
		Hobj := (gamma - s * H) + H - 0.5 * k11 * (gamma - s * H) * (gamma - s * H) - 0.5 * k22 * H * H - s * k12 * (gamma - s * H) * H - y1 * (gamma - s * H) * v1 - y2 * H * v2;

		if (Lobj > Hobj + m_eps)
		then
       begin
	  		a2 := L;
		end
		else

		if (Lobj < Hobj - m_eps)
		then
       begin
	  		a2 := H;
		end
		else
		begin
	  		a2 := alph2;
		end;
      end;
      
      if (abs(a2 - alph2) < m_eps * (a2 + alph2 + m_eps))
      then
      begin
		result:= false;
       EXIT;
      end;
      
      // To prevent precision problems
      if (a2 > C2 - m_Del * C2) 
      then a2 := C2
      else
       if (a2 <= m_Del * C2)
       then a2 := 0;

      // Recompute a1
      a1 := alph1 + s * (alph2 - a2);

      // To prevent precision problems
      if (a1 > C1 - m_Del * C1) 
      then a1 := C1
      else
       if (a1 <= m_Del * C1)
       then a1 := 0;

      // Update sets
      if (a1 > 0) 
      then	m_supportVectors.insert(i1)
      else	m_supportVectors.delete(i1);

      if ((a1 > 0) AND (a1 < C1))
      then	m_I0.insert(i1)
      else	m_I0.delete(i1);

      if ((y1 = 1) AND (a1 = 0))
      then m_I1.insert(i1)
      else	m_I1.delete(i1);

      if ((y1 = -1) AND (a1 = C1))
      then m_I2.insert(i1)
      else	m_I2.delete(i1);

      if ((y1 = 1) AND (a1 = C1))
      then m_I3.insert(i1)
      else	m_I3.delete(i1);

      if ((y1 = -1) AND (a1 = 0))
      then m_I4.insert(i1)
      else	m_I4.delete(i1);

      if (a2 > 0)
      then	m_supportVectors.insert(i2)
      else	m_supportVectors.delete(i2);

      if ((a2 > 0) AND (a2 < C2))
      then	m_I0.insert(i2)
      else	m_I0.delete(i2);

      if ((y2 = 1) AND (a2 = 0))
      then	m_I1.insert(i2)
      else	m_I1.delete(i2);

      if ((y2 = -1) AND (a2 = C2))
      then	m_I2.insert(i2)
      else	m_I2.delete(i2);

      if ((y2 = 1) AND (a2 = C2))
      then	m_I3.insert(i2)
      else	m_I3.delete(i2);

      if ((y2 = -1) AND (a2 = 0))
      then	m_I4.insert(i2)
      else	m_I4.delete(i2);

      // Update weight vector to reflect change a1 and a2, if linear SVM
      if (not(m_useRBF) AND (m_exponent = 1.0))
      then
       begin
		 inst1 := m_data.Number[succ(i1)];
        for p1:= 0 to pred(self.Descriptors.Count) do
         //m_weights[p1] := m_weights[p1]+ y1 * (a1 - alph1) * self.Descriptors.Attribute[p1].cValue[inst1];
         m_weights[p1] := m_weights[p1]+ y1 * (a1 - alph1) * self.FAttTransSVM.cValue[p1,inst1];

		 inst2 := m_data.Number[succ(i2)];
        for p2:= 0 to pred(self.Descriptors.Count) do
         //m_weights[p2] := m_weights[p2] + y2 * (a2 - alph2) * self.Descriptors.Attribute[p2].cValue[inst2];
         m_weights[p2] := m_weights[p2] + y2 * (a2 - alph2) * self.FAttTransSVM.cValue[p2,inst2];

       end;
      
      // Update error cache using new Lagrange multipliers
      j:= m_I0.getNext(-1);
      while (j<>-1) do
       begin
        if (j <> i1) and (j <> i2)
         then m_errors[j] := m_errors[j] + y1 * (a1 - alph1) * m_kernel.eval(i1, j, m_data.Number[succ(i1)]) + y2 * (a2 - alph2) * m_kernel.eval(i2, j, m_data.Number[succ(i2)]);
        j := m_I0.getNext(j)
       end;


      // Update error cache for i1 and i2
      m_errors[i1] := m_errors[i1] + y1 * (a1 - alph1) * k11 + y2 * (a2 - alph2) * k12;
      m_errors[i2] := m_errors[i2] + y1 * (a1 - alph1) * k12 + y2 * (a2 - alph2) * k22;

      // Update array with Lagrange multipliers
      m_alpha[i1] := a1;
      m_alpha[i2] := a2;

      // Update thresholds
      m_bLow := -Math.MAXDOUBLE; m_bUp := Math.MAXDOUBLE;
      m_iLow := -1; m_iUp := -1;

      j:= m_I0.getNext(-1);
      while (j<>-1) do
       begin

		if (m_errors[j] < m_bUp)
		then
       begin
	  		m_bUp := m_errors[j]; m_iUp := j;
		end;

		if (m_errors[j] > m_bLow)
		then
       begin
	  		m_bLow := m_errors[j]; m_iLow := j;
		end;

       j:= m_I0.getNext(j);
       end;

      
      if not(m_I0.contains(i1))
      then
      begin
		if m_I3.contains(i1) OR m_I4.contains(i1)
       then
		begin
	  		if (m_errors[i1] > m_bLow)
	  		then
           begin
	    		m_bLow := m_errors[i1]; m_iLow := i1;
	  		end;
		end
		else
		begin
	  		if (m_errors[i1] < m_bUp)
	  		then
           begin
	    		m_bUp := m_errors[i1]; m_iUp := i1;
	  		end;
		end;
      end;
      
      if not(m_I0.contains(i2))
      then
      begin
		if m_I3.contains(i2) OR m_I4.contains(i2)
		then
       begin
	  		if (m_errors[i2] > m_bLow)
	  		then
           begin
	    		m_bLow := m_errors[i2]; m_iLow := i2;
	  		end;
		end
		else
		begin
	  		if (m_errors[i2] < m_bUp)
	  		then
           begin
	    		m_bUp := m_errors[i2]; m_iUp := i2;
	  		end;
		end;
      end;
      
      if ((m_iLow = -1) OR (m_iUp = -1))
      then
      begin
		raise Exception.Create('This should never happen! -- TakeStep of TBInarySOM');
      end;

      // Made some progress.
      result:= true;
end;

procedure TBinarySMO.buildClassifier;
var i: integer;
    numChanged: integer;
    examineAll: boolean;
begin
      // Initialize some variables
      m_bUp := -1; m_bLow := 1; m_b := 0;

      //idem que Finalize ou setLength(0)
      m_alpha := nil; m_weights := nil; m_errors := nil;
      //m_logistic := nil;
      m_I0 := nil; m_I1 := nil; m_I2 := nil;
      m_I3 := nil; m_I4 := nil;
      //m_sparseWeights := nil; m_sparseIndices := nil;

      // Store the sum of weights
      m_sumOfWeights := m_data.Size;

      // Set class values
      //m_class = new double[insts.numInstances()];
      setLength(m_class,m_data.Size);
      m_iUp := -1; m_iLow := -1;

      //*********************************************************************************//
      //**** remplir le tableau des classes -- le codage influe sur le signe des coefs. *//
      //*********************************************************************************//
      
      for i:= 0 to pred(Length(m_class)) do
       begin
        //l'attribut est forcment binaire ("1"/"2") -- vrifi par la classe d'appel Operator...
        if (self.ClassAttribute.dValue[m_data.Number[succ(i)]] = 1)
         then
          begin
           m_class[i]:= -1.0;
           m_iLow:= i;

           //TraceLog.WriteToLogFile(format('add low = %d, classe = 1',[m_iLow]));
          end
         else
          begin
           m_class[i]:= +1.0;
           m_iUp:= i;

           //TraceLog.WriteToLogFile(format('add up = %d, classe = 2',[m_iUp]));
          end;
       end;

      //**********************************************************************************//

      // Check whether one or both classes are missing
      if ((m_iUp = -1) OR (m_iLow = -1))
      then
      begin
		if (m_iUp <> -1)
		then
       begin
	  		m_b := -1;
		end
		else
       begin
		  if (m_iLow <> -1)
		  then
         begin
             m_b := 1;
         end
         else
         begin
             m_class := nil;
             EXIT;
         end;
       end;
      end;

       (*
		if (not(m_useRBF) AND m_exponent = 1.0)
		{
	  		m_sparseWeights = new double[0];
	  		m_sparseIndices = new int[0];
	  		m_class = null;
		}
		else
		{
	  		m_supportVectors = new SMOset(0);
	  		m_alpha = new double[0];
	  		m_class = new double[0];
		}
       *)

       (*
		// Fit sigmoid if requested
		if (fitLogistic)
		{
	  		fitLogistic(insts, cl1, cl2, numFolds, new Random(randomSeed));
		}
		return;
      end;
      *)

      // Set the reference to the data
      //m_data = insts;

      // If machine is linear, reserve space for weights
      if not(m_useRBF) AND (m_exponent = 1.0)
      then
      begin
		//m_weights = new double[m_data.numAttributes()];
       setLength(m_weights,self.Descriptors.Count);
      end
      else
      begin
		m_weights := nil;
      end;

      // Initialize alpha array to zero
      setLength(m_alpha,m_data.Size);

      // Initialize sets
      m_supportVectors := TSMOset.Create(m_data.Size);
      m_I0 := TSMOset.create(m_data.Size);
      m_I1 := TSMOSet.Create(m_data.Size);
      m_I2 := TSMOSet.Create(m_data.Size);
      m_I3 := TSMOSet.Create(m_data.Size);
      m_I4 := TSMOSet.Create(m_data.Size);

      // Clean out some instance variables
      (*
      m_sparseWeights = null;
      m_sparseIndices = null;
      *)

      // Initialize error cache
      setLength(m_errors,m_data.Size);

      m_errors[m_iLow] := 1; m_errors[m_iUp] := -1;

      // Initialize kernel
      if(m_useRBF)
      then
      begin
		m_kernel := TRBFKernel.Create(self, m_data, m_cacheSize, m_gamma);
      end
      else
      begin
		if (m_featureSpaceNormalization)
		then
       begin
           m_kernel:= TNormalizedPolyKernel.Create(self, m_data, m_cacheSize, m_exponent, m_lowerOrder);
		end
		else
		begin
	  		m_kernel := TPolyKernel.Create(self, m_data, m_cacheSize, m_exponent, m_lowerOrder);
		end;
      end;

      // Build up I1 and I4
      for i := 0 to pred(length(m_class)) do
      begin
		if (m_class[i] = 1)
		then
       begin
	  		m_I1.insert(i);
		end
		else
		begin
	  		m_I4.insert(i);
		end;
      end;
      
      // Loop to find all the support vectors
      numChanged := 0;
      examineAll := true;
      
      while ((numChanged > 0) OR examineAll) do
      begin

       //vrif. pour comparaison avec WEKA
       (*
       TraceLog.WriteToLogFile(Format('numChanged = %d, examineAll = %d',[numChanged,ord(examineAll)]));
       *)

		numChanged := 0;
		
		if (examineAll) 
		then
       begin
	  		//for (int i = 0; i < m_alpha.length; i++)
           for i:= 0 to pred(Length(m_alpha)) do
	  		begin
	    		if (examineExample(i))
	    		then
               begin
	      			inc(numChanged);
	    		end;
	  		end;
		end
		else
		begin

	  		// This code implements Modification 1 from Keerthi et al.'s paper
	  		//for (int i = 0; i < m_alpha.length; i++)

           for i:= 0 to pred(Length(m_alpha)) do
	  		begin
	    		//if ((m_alpha[i] > 0) && (m_alpha[i] < m_C * m_data.instance(i).weight()))
               if ((m_alpha[i] > 0) AND (m_alpha[i] < m_C * 1.0))
	    		then
               begin
	      			if (examineExample(i))
	      			then
                   begin
						inc(numChanged);
	      			end;

	      			// Is optimality on unbound vectors obtained?
	      			if (m_bUp > m_bLow - 2 * m_tol)
	      			then
                   begin
						numChanged := 0;
						break;
	      			end;
	    		end;
	  		end;

	  		//This is the code for Modification 2 from Keerthi et al.'s paper
           (*
	  		/*boolean innerLoopSuccess = true;
	    	numChanged = 0;
	    	while ((m_bUp < m_bLow - 2 * m_tol) && (innerLoopSuccess == true)) {
	    	innerLoopSuccess = takeStep(m_iUp, m_iLow, m_errors[m_iLow]);
	    	}*/
           *)
		end;

		if (examineAll)
		then
       begin
	  		examineAll := false;
		end
		else
       begin
			if (numChanged = 0)
			then
           begin
	  			examineAll := true;
			end;
       end;
       
    end;//du while

    // Set threshold
    m_b := (m_bLow + m_bUp) / 2.0;

    // Save memory
    m_kernel.clean();

    m_errors := nil;
    m_I0 := nil;
    m_I1 := nil;
    m_I2 := nil;
    m_I3 := nil;
    m_I4 := nil;

    (* -- complique trop la chose pour un gain  mesurer plus tard --
    // If machine is linear, delete training data
    // and store weight vector in sparse format
    *)

end;

function TBinarySMO.coreLearning(examples: TExamples): boolean;
begin
 TRY
 self.runClassifier(examples);
 TraceLog.WriteToLogFile(Format('[SMO] Number of kernels evals = %d',[m_kernel.numEvals()]));
 result:= TRUE;
 EXCEPT
 result:= FALSE;
 END;
end;

procedure TBinarySMO.setDefaultWEKAParameters;
begin

  //************************************
  //**** paramtrables par l'utilisateur
  //************************************

  //** paramtres de mthode

  //** Whether to normalize/standardize/neither */
  m_filterType := atSVM_NORMALIZE;
  //** Feature-space normalization? -- private boolean m_featureSpaceNormalization = false;
  m_featureSpaceNormalization:= false;
  //** Use RBF kernel? (default: poly) -- private boolean m_useRBF = false;
  m_useRBF:= false;
  //** The exponent for the polynomial kernel. -- private double m_exponent = 1.0;
  m_exponent:= 1.0;
  //** Gamma for the RBF kernel. -- private double m_gamma = 0.01;
  m_gamma:= 0.01;

  //** paramtres de calcul
  
  //** The complexity parameter. -- private double m_C = 1.0;
  m_C:= 1.0;
  //** Epsilon for rounding. -- private double m_eps = 1.0e-12;
  m_eps:= 1.0e-12;
  //** Tolerance for accuracy of result. -- private double m_tol = 1.0e-3;
  m_tol:= 1.0e-3;
  //** The random number seed  -- private int m_randomSeed = 1;
  m_randomSeed:= 1;

  //**********************
  //**** non-paramtrables
  //**********************

  //** Use lower-order terms? -- private boolean m_lowerOrder = false;
  m_lowerOrder:= false;
  //** The size of the cache (a prime number) -- private int m_cacheSize = 1000003; //>> old << m_cacheSize:= 1000003;
  //>>ver. 1.53.2.1
  m_cacheSize:= 250007;
  //** Only numeric attributes in the dataset? -- private boolean m_onlyNumeric;
  m_onlyNumeric:= true;
  //** Precision constant for updating sets -- private static double m_Del = 1000 * Double.MIN_VALUE;
  m_Del:= 1000*Math.MinDouble;
end;

procedure TBinarySMO.getTANAGRAParameters;
var prm: TOpPrmSVM;
begin
 prm:= self.OpPrmSpv as TOpPrmSVM;
 
 //******************************************************************
 //**** affecter les paramtres modifiables dans la bote de dialogue
 //******************************************************************

 //>>
 //** The exponent for the polynomial kernel. -- private double m_exponent = 1.0;
 m_exponent:= prm.Exponent;
 //** Whether to normalize/standardize/neither -- m_filterType := atSVM_NORMALIZE;
 m_filterType:= prm.FilterType;
 //** Feature-space normalization? -- private boolean m_featureSpaceNormalization = false;
 m_featureSpaceNormalization:= prm.FeatureSpaceNormalization;
 //** Use RBF kernel? (default: poly) -- private boolean m_useRBF = false;
 m_useRBF:= prm.UseRBF;
 //** Gamma for the RBF kernel. -- private double m_gamma = 0.01;
 m_gamma:= prm.Gamma;

 //>>
 //** The complexity parameter. -- private double m_C = 1.0;
 m_C:= prm.Complexity;
 //** Epsilon for rounding. -- private double m_eps = 1.0e-12;
 m_eps:= prm.Epsilon;
 //** Tolerance for accuracy of result. -- private double m_tol = 1.0e-3;
 m_tol:= prm.Tolerance;

end;

procedure TBinarySMO.getScore(example: integer; var postProba: TTabScore);
var value: double;
begin
 //il faut bien tenter qq chose ( valider)
 TRY
  value:= self.SVMOutput(-1,example);
  postProba[1]:= 1.0/(1.0+exp(value));
  postProba[2]:= 1.0-postProba[1];
  postProba[0]:= 1.0;
 EXCEPT
  postProba.raz();
 END;
end;

procedure TBinarySMO.classification(example: integer;
  var response: TTypeDiscrete);
begin
 //#ToDo1 -- en pleine prospective pour l'instant
 //appliquer l'output du SVM et affecter avec un seuil de 0
 TRY
  if (self.SVMOutput(-1,example) <= 0)
   then response:= 1
   else response:= 2;
 EXCEPT
  response:= 1;
 END;
end;

function TBinarySMO.getHTMLResults: string;
var s: string;
    j: integer;
begin
 s:= '';
 //si SVM linaire
 if not(m_useRBF) and (m_exponent = 1.0)
  then
   begin
    s:= s+'<H4>Linear classifier</H4>';
    s:= s+HTML_HEADER_TABLE_RESULT;
    s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>Weight</TH></TR>';
    //les coefs.
    for j:= 0 to pred(self.Descriptors.Count) do
     s:= s+HTML_TABLE_COLOR_DATA_GRAY+Format('<td>%s</td><td align=right>%.4f</td></tr>',[self.Descriptors.Attribute[j].Name,m_weights[j]]);
    //la constante
    s:= s+HTML_TABLE_COLOR_DATA_GRAY+Format('<td>constant</td><td align=right>%.4f</td></tr>',[-1.0*m_b]);//pourquoi -1 ??? (cf. WEKA)
    s:= s+'</table>';
   end
  else
   begin
    //afficher les points supports
    s:= s+'<H4>Support vectors</H4>';
    s:= s+Format('Number of support vectors = %d',[m_supportVectors.numElements()]);
   end;
 //and then...
 result:= s;
end;

procedure TBinarySMO.computeInternalStatistics;
begin
 //attribut de normalisation
 if assigned(FAttTransSVM) then FreeAndNil(FAttTransSVM);
 case m_filterType of
  atSVM_NONE: FAttTransSVM:= TAttTrans.create(self.Descriptors,self.m_data);
  atSVM_STANDARDIZE: FAttTransSVM:= TAttTransStandardize.create(self.Descriptors,self.m_data)
  else FAttTransSVM:= TAttTransNormalize.create(self.Descriptors,self.m_data); 
 end;
end;

procedure TBinarySMO.destroyStructures;
begin
 {$IFDEF SMO_OWNER_M_DATA}
 if assigned(m_data) then FreeAndNil(m_data);
 {$ENDIF}
end;

{ TKernel }

constructor TKernel.create(operator: TBinarySMO);
begin
 inherited Create();
 FOperator:= operator;
 //
 TraceLog.WriteToLogFile(format('[SMO] use <%s> kernel evaluation',[self.ClassName])); 
end;

end.
