unit UDlgOpPrmSVM;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit;

type
  TdlgOpPrmSpvSVM = class(TDlgBaseOperatorParameter)
    TabSheet1: TTabSheet;
    rgKernel: TRadioGroup;
    Label1: TLabel;
    spinExponent: TLMDSpinEdit;
    rgAttTrans: TRadioGroup;
    edGamma: TLMDMaskEdit;
    Label2: TLabel;
    TabSheet2: TTabSheet;
    edEpsilon: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    edTolerance: TEdit;
    Label3: TLabel;
    edComplexity: TEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;    
  end;

var
  dlgOpPrmSpvSVM: TdlgOpPrmSpvSVM;

implementation

uses UCompSpvSVM, UCalcSpvSMOAttTransformation;

{$R *.dfm}

{ TdlgOpPrmSpvSVM }

procedure TdlgOpPrmSpvSVM.ApplyModifications;
var prm: TOpPrmSVM;
begin
 prm:= self.OpPrm as TOpPrmSVM;
 //standard est zro -- polynome
 prm.FeatureSpaceNormalization:= false;
 prm.UseRBF:= false;
 //c'est trs mal fait mais au moins on est totalement en accord avec WEKA
 case self.rgKernel.ItemIndex of
  //polynome normalis
  1: prm.FeatureSpaceNormalization:= true;
  //si demande RBF, a passera  2
  2: prm.UseRBF:= true;
 end;
 //exponsant pour polynome
 prm.Exponent:= self.spinExponent.Value;
 //transformation des attributs
 prm.FilterType:= TEnumAttTransformSVM(self.rgAttTrans.ItemIndex);
 TRY
 //gamma du RBF
 prm.Gamma:= StrToFloat(self.edGamma.Text);
 //paramtres de calcul
 prm.Complexity:= StrToFloat(self.edComplexity.Text);
 prm.Epsilon:= StrToFloat(self.edEpsilon.Text);
 prm.Tolerance:= StrToFloat(self.edTolerance.Text);
 EXCEPT
 //rien mais les paramtres ne sont pas rcuprs
 END;

end;

procedure TdlgOpPrmSpvSVM.SetParameters;
var prm: TOpPrmSVM;
begin
 prm:= self.OpPrm as TOpPrmSVM;
 //standard est zro -- polynome
 self.rgKernel.ItemIndex:= ord(prm.FeatureSpaceNormalization);
 //si demande RBF, a passera  2
 if prm.UseRBF
  then self.rgKernel.ItemIndex:= 2;
 //exposant pour polynome
 self.spinExponent.Value:= prm.Exponent;
 //gamma pour le RBF
 self.edGamma.Text:= FormatFloat('0.0000',prm.Gamma);
 //transformation des attributs
 self.rgAttTrans.ItemIndex:= ord(prm.FilterType);
 //paramtres de calcul... 
 self.edComplexity.Text:= FormatFloat('0.0000',prm.Complexity);
 self.edEpsilon.Text   := FloatToStr(prm.Epsilon);
 self.edTolerance.Text := FloatToStr(prm.Tolerance);
end;

end.
