unit UDlgOpPrmSpvAssesBVDecomposition;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA;

type
  TdlgOpPrmSpvAssesBVDecomposition = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinIterations: TLMDSpinEdit;
    spinTestSize: TLMDSpinEdit;
    spinTrainPoolSize: TLMDSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;      
  end;

var
  dlgOpPrmSpvAssesBVDecomposition: TdlgOpPrmSpvAssesBVDecomposition;

implementation

uses UCompSpvAssesBVDecomposition;

{$R *.dfm}

{ TdlgOpPrmSpvAssesBVDecomposition }

procedure TdlgOpPrmSpvAssesBVDecomposition.ApplyModifications;
var prm: TOpPrmAssesBVar;
begin
 prm:= OpPrm as TOpPrmAssesBVar;
 prm.NbIterations:= self.spinIterations.Value;
 prm.RelSizeTest:= 1.0*self.spinTestSize.Value/100.0;
 prm.RelSizeTrainingPool:= 1.0*self.spinTrainPoolSize.Value/100.0;
end;

procedure TdlgOpPrmSpvAssesBVDecomposition.SetParameters;
var prm: TOpPrmAssesBVar;
begin
 prm:= OpPrm as TOpPrmAssesBVar;
 self.spinIterations.Value:= prm.NbIterations;
 self.spinTestSize.Value:= TRUNC(100.0*prm.RelSizeTest);
 self.spinTrainPoolSize.Value:= TRUNC(100.0*prm.RelSizeTrainingPool);
end;

end.
