(*******************************************************************)
(* UDlgOpPrmSpvAssesCV.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

unit UDlgOpPrmSpvAssesCV;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomBrowseEdit,
  LMDFileSaveEdit;

type
  TDlgOpPrmSpvAssesCV = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    Label2: TLabel;
    spinRepetitions: TLMDSpinEdit;
    spinFolds: TLMDSpinEdit;
    GroupBox1: TGroupBox;
    chkSave: TCheckBox;
    edSave: TLMDFileSaveEdit;
    procedure chkSaveClick(Sender: TObject);
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSpvAssesCV: TDlgOpPrmSpvAssesCV;

implementation

uses UCompSpvAssesCrossValidation;

{$R *.dfm}

{ TDlgOpPrmSpvAssesCV }

procedure TDlgOpPrmSpvAssesCV.ApplyModifications;
var prm: TOpPrmAssesCV;
begin
 prm:= OpPrm as TOpPrmAssesCV;
 prm.NbRepetitions:= self.spinRepetitions.Value;
 prm.NbFolds:= self.spinFolds.Value;
 prm.SaveResults:= self.chkSave.Checked;
 prm.FileNameResults:= self.edSave.Filename; 
end;

procedure TDlgOpPrmSpvAssesCV.SetParameters;
var prm: TOpPrmAssesCV;
begin
 prm:= OpPrm as TOpPrmAssesCV;
 self.spinRepetitions.Value:= prm.NbRepetitions;
 self.spinFolds.Value:= prm.NbFolds;
 self.chkSave.Checked:= prm.SaveResults;
 self.edSave.Filename:= prm.FileNameResults;
 //
 self.chkSaveClick(NIL); 
end;

procedure TDlgOpPrmSpvAssesCV.chkSaveClick(Sender: TObject);
begin
 if self.chkSave.Checked
  then self.edSave.Enabled:= TRUE
  else self.edSave.Enabled:= FALSE;
end;

end.
