(**********************************************************************)
(* UCompSpvAssesTrainTest.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

{
@abstract(Subdivision apprentisssage-test pour l'valuation d'un classifieur)
@author(Ricco)
@created(12/01/2004)
Il est possible de rpeter la procdure, il y a donc 2 paramtres : nombre de rptitions,
et taille relative de l'chantillon d'apprentissage.
}
unit UCompSpvAssesTrainTest;

interface

USES
        Forms,Classes,
        IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompSpvAssesDefinition;

TYPE

        {gnrateur de train-test}
        TMLGenCompAssesTrainTest = class(TMLGenComp)
                                   protected
                                   procedure   GenCompInitializations(); override;
                                   public
                                   function    GetClassMLComponent: TClassMLComponent; override;
                                   end;

        {composant train-test}
        TMLCompAssesTrainTest = class(TMLCompSpvAsses)
                                protected
                                function    getClassOperator: TClassOperator; override;
                                end;

        {oprateur}
        TOpAssesTrainTest = class(TOpSpvAsses)
                            private
                            {tableau des effectifs en test}
                            FTabTestSize: array of double;
                            {tableau des taux d'erreur en test}
                            FTabTestErr: array of double;
                            protected
                            procedure   ReInitialize(); override;
                            procedure   PrepareConfMatrix(); override;
                            function    getClassParameter: TClassOperatorParameter; override;    
                            procedure   AssesExecution(); override;
                            public
                            function    getHTMLResultsSummary(): string; override;
                            end;

        {paramtrage de l'oprateur}
        TOpPrmAssesTrainTest = class(TOpPrmSpvAsses)
                               private
                               {proportion en apprentissage}
                               FProportionTrainSet: single;
                               {Nombre de rptitions}
                               FNbRepetitions: integer; 
                               protected
                               function    CreateDlgParameters(): TForm; override;
                               procedure   SetDefaultParameters(); override;
                               public
                               procedure   LoadFromStream(prmStream: TStream); override;
                               procedure   SaveToStream(prmStream: TStream); override;
                               procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                               procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                               function    getHTMLParameters(): string; override;
                               property    ProportionTrainSet: single read FProportionTrainSet write FProportionTrainSet;
                               property    NbRepetitions: integer read FNbRepetitions write FNbRepetitions;
                               end;

implementation

uses
        Sysutils,
        UDatasetExamples, UCompSpvLDefinition, UDatasetImplementation,
        UConstConfiguration, UDlgOpPrmTrainTest, UStringsResources;

{ TMLGenCompAssesTrainTest }

procedure TMLGenCompAssesTrainTest.GenCompInitializations;
begin
 FMLComp:= mlcSpvAssessment;
end;

function TMLGenCompAssesTrainTest.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssesTrainTest;
end;

{ TMLCompAssesTrainTest }

function TMLCompAssesTrainTest.getClassOperator: TClassOperator;
begin
 result:= TOpAssesTrainTest;
end;

{ TOpAssesTrainTest }

procedure TOpAssesTrainTest.AssesExecution;
var test: TExamples;
    tmpCM: TConfusionMatrix;
    i: integer;
    proportion: single;
begin
 //rcup le paramtre
 proportion:= (PrmOp as TOpPrmAssesTrainTest).ProportionTrainSet;
 //test sample
 test:= TExamples.Create(AllExamples.Size);
 //lancer les oprations
 for i:= 1 to (PrmOp as TOpPrmAssesTrainTest).NbRepetitions do
  begin
   //subdiviser app-test
   AllExamples.SamplingSplitting(proportion,RootExamples,test);
   //lancer l'apprentissage
   CompMetaSpv.Execute(TRUE);
   //matrice de confusion
   tmpCM:= TConfusionMatrix.create(CompMetaSpv.OutputData.LstAtts[asTarget].Attribute[0],CompMetaSpv.PredClass,test);
   ConfMatrixAsses.addOtherConfMatrix(tmpCM);
   FTabTestSize[i]:= test.Size;
   FTabTestErr[i]:= tmpCM.getErrorRate();
   tmpCM.Free;
  end;
 test.Free;
end;

function TOpAssesTrainTest.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssesTrainTest;
end;

function TOpAssesTrainTest.getHTMLResultsSummary: string;
var s: string;
    i: integer;    
begin
 //taille de l'chantillon initial
 s:= format('<P><B>Dataset size : %d </B>',[AllExamples.Size]); 
 //pour chaque essai
 s:= s+'<P><B>Tests error rate</B><BR>';
 s:= s+HTML_HEADER_TABLE_RESULT+
       HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Trial</TH><TH>Train size</TH><TH>Test size</TH><TH>Error rate</TH></TR>';
 for i:= 1 to (PrmOp as TOpPrmAssesTrainTest).NbRepetitions do
  s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>%d</TD><td align=right>%d</td><TD align=right>%.0f</TD><TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD>',
                                          [i,AllExamples.Size-trunc(FTabTestSize[i]),FTabTestSize[i],FTabTestErr[i]]);
 s:= s+'</table>';
 //le tableau rcapitulatif
 s:= s+'<P><B>Overral test error rate</B><BR>';
 s:= s+ConfMatrixAsses.getHTMLResults();
 //envoyer le tout
 result:= s;
end;

procedure TOpAssesTrainTest.PrepareConfMatrix;
begin
 inherited PrepareConfMatrix();
 //puis les tableaux
 setLength(FTabTestSize,succ((PrmOp as TOpPrmAssesTrainTest).NbRepetitions));
 setLength(FTabTestErr,succ((PrmOp as TOpPrmAssesTrainTest).NbRepetitions));
end;

procedure TOpAssesTrainTest.ReInitialize;
begin
 inherited ReInitialize();
 setLength(FTabTestSize,0);
 setLength(FTabTestErr,0);
end;

{ TOpPrmAssesTrainTest }

function TOpPrmAssesTrainTest.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssesTrainTest.CreateFromOpPrm(self);
end;

function TOpPrmAssesTrainTest.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Train-test parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Train proportion</TD><TD align="right">%.2f</TD></TR>',[FProportionTrainSet]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Trials</TD><TD align="right">%d</TD></TR>',[FNbRepetitions]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmAssesTrainTest.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited;
 FProportionTrainSet:= prmINI.ReadFloat(prmSection,'train_proportion',FProportionTrainSet);
 FNbRepetitions:= prmINI.ReadInteger(prmSection,'nb_repetitions',FNbRepetitions);
end;

procedure TOpPrmAssesTrainTest.LoadFromStream(prmStream: TStream);
begin
 inherited;
 prmStream.ReadBuffer(FProportionTrainSet,sizeof(FProportionTrainSet));
 prmStream.ReadBuffer(FNbRepetitions,sizeof(FNbRepetitions));
end;

procedure TOpPrmAssesTrainTest.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited;
 prmINI.WriteFloat(prmSection,'train_proportion',FProportionTrainSet);
 prmINI.WriteInteger(prmSection,'nb_repetitions',FNbRepetitions);
end;

procedure TOpPrmAssesTrainTest.SaveToStream(prmStream: TStream);
begin
 inherited;
 prmStream.WriteBuffer(FProportionTrainSet,sizeof(FProportionTrainSet));
 prmStream.WriteBuffer(FNbRepetitions,sizeof(FNbRepetitions));
end;

procedure TOpPrmAssesTrainTest.SetDefaultParameters;
begin
 inherited;
 FProportionTrainSet:= 0.70;
 FNbRepetitions:= 1;
end;

initialization
 RegisterClass(TMLGenCompAssesTrainTest);
end.
