(***********************************************************************)
(* UCompSpvAssesDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Classe de base pour l'valuation des mthodes supervises)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSpvAssesDefinition;

interface

USES
        Classes,
        IniFiles,
        UDatasetExamples,
        UCompDefinition,
        UOperatorDefinition,
        UCompSpvLDefinition;

TYPE
        {composant gnrique, n'envoie rien en sortie et n'a pas de successeur}
        TMLCompSpvAsses = class(TMLComponent)
                          protected
                          function    GetLogResultDescription(): string; override;
                          {prparer l'excution}
                          function  BeforeExecution(): boolean; override;
                          {aprs l'excution}
                          function  AfterExecution(): boolean; override;
                          public
                          {aucune connexion possible en sortie}
                          function  isConnectable(prmGen: TMLGenComp): boolean; override;
                          {ne rpond pas de la mme manire que les autres composants car pas de successeurs}
                          procedure InvalidateForExecution(); override;
                          {rien en sortie}
                          procedure   RefreshOutput(); override;
                          end;

        {oprateur gnrique}
        TOpSpvAsses = class(TOperator)
                      private
                      {les exemples  manipuler de la racine --  fixer itrativement pour le training}
                      FRootExamples: TExamples;
                      {l'ensemble des exemples initiaux, mis de ct -- ne jamais modifier !}
                      FTempAllExamples: TExamples;
                      {composant meta supervised prcdent}
                      FCompMetaSpv: TMLCompMetaSpvLearning;
                      {la matrice de confusion globale}
                      FConfMatrixAsses: TConfusionMatrix;
                      {indicateur indiquant que l'excution est en cours}
                      FUnderExecution: boolean;
                      protected
                      {rinitialisation}
                      procedure   ReInitialize(); override;
                      {prparer la matrice de confusion}
                      function    CoreExecute(): boolean; override;
                      {construire la matrice de confusion}
                      procedure   PrepareConfMatrix(); virtual;
                      {lancer l'excution de l'valuation du classifieur - surcharge obligatoire}
                      procedure   AssesExecution(); virtual; abstract;
                      {lancer une dernire fois avec tous les individus pour tout rinitialiser}
                      procedure   LastExecution(); virtual;
                      {sauvegarder les donnes dans un fichier -- new -- 13/10/2004}
                      procedure   SaveResultsToFile();
                      public
                      {rcupration du pointeur d'individus sur le sommet racine du diagramme}
                      constructor Create(AOwner: TObject); override;
                      destructor  Destroy; override;
                      {rcuprer le taux d'erreur}
                      function    getErrorRate(): double; virtual;
                      {les exemples  manipuler}
                      property    RootExamples: TExamples read FRootExamples;
                      {tous les individus}
                      property    AllExamples: TExamples read FTempAllExamples;
                      {le composant meta-spv}
                      property    CompMetaSpv: TMLCompMetaSpvLearning read FCompMetaSpv;
                      {matrice de confusion}
                      property    ConfMatrixAsses: TConfusionMatrix read FConfMatrixAsses;
                      {indicateur d'excution courante}
                      property    UnderExecution: boolean read FUnderExecution;
                      end;

        {paramtrage gnrique}
        TOpPrmSpvAsses = class(TOperatorParameter)
                         private
                         {08/10/2004 -- faut-il sauver les rsultats dans un fichier  part -- pour les exps}
                         FSaveResults: boolean;
                         {08/10/2004 -- nom du fichier de sauvegarde}
                         FFileNameResults: string;
                         {obtenir le chemin de l'EXE}
                         function    getExePath(): string;
                         protected
                         procedure   SetDefaultParameters(); override;
                         public
                         //E/S
                         procedure   LoadFromStream(prmStream: TStream); override;
                         procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                         procedure   SaveToStream(prmStream: TStream); override;
                         procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                         //proprits
                         property    SaveResults: Boolean read FSaveResults write FSaveResults;
                         property    FileNameResults: string read FFileNameResults write FFileNameResults;
                         end;

CONST
        {ERROR CODE sur le taux d'erreur calcul}
        ERR_ASSES_ERROR_RATE = -1.0;

implementation

uses
        Sysutils,
        Forms,
        UStringAddBuffered,
        UCompDataset,
        UDatasetImplementation, ULogFile;

{ TOpSpvAsses }

function TOpSpvAsses.CoreExecute: boolean;
begin
 result:= true;
 TRY
 self.PrepareConfMatrix();
 FUnderExecution:= TRUE;
 self.AssesExecution();
 self.LastExecution();
 //new -- 13/10/2004 -- effectuer la sauvegarde sur le fichier le cas chant
 if (self.PrmOp as TOpPrmSpvAsses).SaveResults
  then self.SaveResultsToFile();
 //--------------------------------------------------------------------------
 FUnderExecution:= FALSE;
 EXCEPT
 result:= false;
 END;
end;

constructor TOpSpvAsses.Create(AOwner: TObject);
var root: TMLCompDataset;
begin
 inherited Create(Aowner);
 //pointer sur la racine
 root:= (MLOwner as TMLComponent).Diagram.RootMLComp as TMLCompDataset;
 //les individus sur la racine
 FRootExamples:= root.OutputData.Examples;
 //tous les individus
 FTempAllExamples:= TExamples.Create(FRootExamples.Size);
 FTempAllExamples.Copy(FRootExamples);
 //le composant meta supervis, si le cast est mauvais c'est qu'il y a problme
 FCompMetaSpv:= (MLOwner as TMLComponent).Predecessor as TMLCompMetaSpvLearning;
 //pas d'excution courante
 FUnderExecution:= FALSE;
end;

destructor TOpSpvAsses.Destroy;
begin
 if assigned(FTempAllExamples)
  then FreeAndNil(FTempAllExamples);
 if assigned(FConfMatrixAsses)
  then FreeAndNil(FConfMatrixAsses);
 inherited destroy;
end;

function TOpSpvAsses.getErrorRate: double;
begin
 if assigned(FConfMatrixAsses)
  then result:= FConfMatrixAsses.getErrorRate()
  else result:= ERR_ASSES_ERROR_RATE;
end;

procedure TOpSpvAsses.LastExecution;
begin
 //recopier tous les individus dans le sommet initial
 FRootExamples.Copy(FTempAllExamples);
 //relancer l'execution sur tout le chemin, avec tous les individus
 FCompMetaSpv.Execute(TRUE);
end;

procedure TOpSpvAsses.PrepareConfMatrix;
begin
 //si on est l c'est que c'est bon pour la dfinition de l'endogne, pas besoin de vrifs trop pousses
 FConfMatrixAsses:= TConfusionMatrix.createStructure(FCompMetaSpv.OutputData.LstAtts[asTarget].Attribute[0]);
end;

procedure TOpSpvAsses.ReInitialize;
begin
 inherited ReInitialize();
 if assigned(FConfMatrixAsses)
  then FreeAndNil(FConfMatrixAsses);
end;

procedure TOpSpvAsses.SaveResultsToFile;
var sFileName: string;
    FFile: TextFile;
    curComp: TMLComponent;
    sResults: string;
begin
 sFileName:= (self.PrmOp as TOpPrmSpvAsses).FileNameResults;
 //dvelopper si ce n'est pas le cas
 sFileName:= ExpandUNCFileName(sFileName);
 TRY
  //composant associ  l'oprateur
  curComp:= self.MLOwner as TMLComponent;
  //accder au fichier
  AssignFile(FFile,sFileName);
  if FileExists(sFileName) then Append(FFile)
                           else Rewrite(FFile);
  // -- sauvegarde --
  //nom de filire
  sResults:= curComp.Diagram.FileName;
  //nom de la base de donnes
  sResults:= sResults+#9+curComp.Diagram.DatabaseName;
  //date et heure
  sResults:= sResults+#9+DateTimeToStr(Now());
  //nom du composant
  sResults:= sResults+#9+curComp.Description;
  //le rsultat
  sResults:= sResults+#9+format('%.6f',[self.getErrorRate()]);
  //and then...
  Writeln(FFile,sResults);
  //fin de sauvegarde
  CloseFile(FFile);
 EXCEPT
  //ne rien faire en cas d'erreur sauf  le signaler dans le fichier LOG
  On e: Exception
   Do TraceLog.WriteToLogFile(format('[SPV ASSES] --> !!! ERROR !!! during save results into %s (err = %s)',[sFileName,e.Message]));
 END;
end;

{ TMLCompSpvAsses }

function TMLCompSpvAsses.AfterExecution: boolean;
begin
 //finaliser normalement
 result:= inherited AfterExecution();
 //fin de l'assessment
 self.Diagram.AssessmentProcessing:= FALSE;
end;

function TMLCompSpvAsses.BeforeExecution: boolean;
begin
 //annoncer l'assessment
 self.Diagram.AssessmentProcessing:= TRUE;
 //suite normale
 result:= inherited BeforeExecution();
end;

function TMLCompSpvAsses.GetLogResultDescription: string;
begin
 result:= self.ClassName+' operating successfull';
end;

procedure TMLCompSpvAsses.InvalidateForExecution;
begin
 //nothing
end;

function TMLCompSpvAsses.isConnectable(prmGen: TMLGenComp): boolean;
begin
 result:= FALSE;
end;

procedure TMLCompSpvAsses.RefreshOutput;
begin
 //nothing
end;

{ TOpPrmSpvAsses }

function TOpPrmSpvAsses.getExePath: string;
var sPath: string;
begin
 sPath:= ExtractFilePath(Application.ExeName);
 if (sPath[length(sPath)]<>'\')
   then sPath:= sPath+'\';
 result:= sPath;
end;

procedure TOpPrmSpvAsses.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FSaveResults:= prmINI.ReadBool(prmSection,'isSaveResults',FSaveResults);
 FFileNameResults:= prmINI.ReadString(prmSection,'results_filename',FFileNameResults);
end;

procedure TOpPrmSpvAsses.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSaveResults,sizeof(FSaveResults));
 loadStringFromStream(FFileNameResults,prmStream);
end;

procedure TOpPrmSpvAsses.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteBool(prmSection,'isSaveResults',FSaveResults);
 prmINI.WriteString(prmSection,'results_filename',FFileNameResults);
end;

procedure TOpPrmSpvAsses.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSaveResults,sizeof(FSaveResults));
 saveStringToStream(FFileNameResults,prmStream);
end;

procedure TOpPrmSpvAsses.SetDefaultParameters;
begin
 FSaveResults:= FALSE;
 FFileNameResults:= self.getExePath()+'experiments_results.txt';
end;

end.
