(*******************************************************************)
(* UCalcSpvStructScore.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Structure pour grer les scores)
@author(Ricco)
@created(23/04/2005)

Structure pour grer les scores attribus  chaque individu !
}

unit UCalcSpvStructScore;

interface

USES
   UDatasetDefinition,
   UCalcRndGenerator,
   UCalcDistribution;

TYPE
   //type rel utilis -- double prcision
   Float = double;

   {score conscutif  un classement}
   TTabScore = class
               private
               //tableau des valeurs des scores
               FTab: array of Float;
               //attribut classe associe
               FAtt: TAttribute;
               //gnrateur de nombre alatoire pour la gestion des ex-aequo
               FRand: TRndGenerator;
               //Nombre de valeurs
               FSize: integer;
               //calculer la somme
               function    sum(): Float;
               //calculer la valeur min dans le tableau
               function    min(): Float;
               public
               //crer la structure
               constructor create(att: TAttribute);
               //dtruire
               destructor  destroy(); override;
               //attribuer une valeur
               procedure   setValue(index: integer; const value: Float);
               //rcuprer une valeur
               function    getValue(index: integer): Float;
               //renvoyer l'index de la valeur max. dans le tableau, renvoie -1 si le tableau vaut zro
               function    getIndexMax(): integer;
               //normaliser de manire  ce que la somme des scores vaut 1.0
               procedure   normalize();
               //remise  zro
               procedure   raz();
               //rcuprer la distribution  partir d'un tableau de frquence
               procedure   recupFromTabFrequence(source: TTabFrequence);
               //proprit accs aux valeurs
               property    value[index: integer]: Float read getValue write setValue; default;
               end;

implementation

USES
   Math;

{ TTabScore }

constructor TTabScore.create(att: TAttribute);
begin
 inherited Create();
 FAtt:= att;
 FSize:= FAtt.nbValues;
 setLength(FTab,succ(FSize));
 //utiliser toujours la mme squence
 FRand:= TRndGenerator.Create(seedStandard,DEFAULT_SEED_VALUE_1,DEFAULT_SEED_VALUE_2);
end;

destructor TTabScore.destroy;
begin
 Finalize(FTab);
 FRand.Free();
 inherited;
end;

function TTabScore.getIndexMax: integer;
var iMax,i: integer;
    vMax,curValue: Float;
begin
  iMax:= -1;
  vMax:= -1.0*Math.MaxSingle;
  for i:= 1 to FSize do
   begin
    curValue:= FTab[i];
    if (curValue > vMax) OR ((curValue = vMax) and (FRand.RanMar() > 0.5))
     then
      begin
       iMax:= i;
       vMax:= curValue;
      end;
   end;
  result:= iMax;
end;

function TTabScore.getValue(index: integer): Float;
begin
 result:= FTab[index];
end;

function TTabScore.min: Float;
var minValue: Float;
    i: integer;
begin
 minValue:= Math.MaxSingle;
 for i:= 1 to FSize do
  if (FTab[i]<minValue) then minValue:= FTab[i];
 result:= minValue;
end;

procedure TTabScore.normalize;
var minValue: Float;
    i: integer;
begin
 //rcuprer la valeur min
 minValue:= self.min();
 //si min. ngatif, dcaler tout le monde
 if (minValue < 0)
  then
   begin
    minValue:= -1.0*minValue;
    for i:= 1 to FSize do
     FTab[i]:= FTab[i]+minValue;
   end;
 //calculer la marge
 FTab[0]:= self.sum();
 //normaliser maintenant -- la somme doit tre gal  1.0
 if (FTab[0] > 0)
  then
    begin
     for i:= 1 to FSize do
      FTab[i]:= FTab[i]/FTab[0];
     //et automatiquement
     FTab[0]:= 1.0;
    end;
end;

procedure TTabScore.raz;
begin
 FillChar(FTab[0],sizeof(Float)*succ(FSize),0);
end;

procedure TTabScore.recupFromTabFrequence(source: TTabFrequence);
var i: integer;
begin
 for i:= 0 to FSize do
  FTab[i]:= source.Value[i];
end;

procedure TTabScore.setValue(index: integer; const value: Float);
begin
 FTab[index]:= value;
end;

function TTabScore.sum: Float;
var i: integer;
    somme: Float;
begin
 somme:= 0;
 for i:= 1 to FSize do
  somme:= somme+FTab[i];
 result:= somme; 
end;

end.
