(*******************************************************************)
(* UCompSpvLDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Classe de base pour les mthodes supervises)
@author(Ricco)
@created(12/01/2004)
C'est le point central du logiciel, l'ide est de pouvoir enquiller des mthodes, tout en
profitant de la structure construite autour pour enchaner la prparation des donnes (instance
filtering, feature selection, feature construction, rgularisation...) et l'apprentissage supervis proprement dit.
Si la structure est bonne, on est tranquile pour au moins 5 ans d'exps en tout genre dans le domaine.

Trois familles de classes sont dfinies  la base : le meta supervised qui permettra par la suite d'implmenter les
boosting, arcing, etc..., le supervised qui est le composant embedded dans le meta, et la classe de calcul qui s'oocupe
de construire 1 classifieur.
}
unit UCompSpvLDefinition;

interface

USES
        Forms, Menus, Classes,
        IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompManageDataset,
        UDatasetDefinition,
        UDatasetImplementation,
        UDatasetExamples,
        UCalcDistribution,
        UCalcCrossTab,
        UCalcStatDes,
        UCalcRndGenerator,
        UCalcSpvStructScore;

TYPE
        TMLCompSpvLearning = class;
        TOpSpvLearning = class;
        TCalcSpvLearning = class;
        TClassCalcSpvLearning = class of TCalcSpvLearning;

        {la matrice de confusion qui value le rsultat d'un apprentissage supervis}
        TConfusionMatrix = class(TObject)
                           private
                           {attribut  prdire}
                           FClassAttribute: TAttribute;
                           {new -- 18/07/2005 -- attribut de prdiction que l'on confronte}
                           FPredAttribute: TAttribute;
                           {tableau interne de comptage}
                           FCrossTab: TCrossTab;
                           {la sensibilit pour une modalit}
                           function getSensibility(k: integer): double;
                           {la prcision pour une modalit}
                           function getAccuracy(k: integer): double;
                           public
                           {std}
                           constructor create(prmClassAtt, prmPredAtt: TAttribute; prmExamples: TExamples);
                           constructor createStructure(prmClassAtt: TAttribute);
                           {dtruire le tableau}
                           destructor  destroy; override;
                           {reconnecter un attribut en prdiction}
                           function    connectPredAttribute(attPred: TAttribute): boolean;
                           {on peut la recalculer  la vole, en modifiant les individus slectionns par exemple}
                           procedure   refresh(prmExamples: TExamples);
                           {renvoyer les rsultats : le tableau mais aussi qqs indicateurs supplmentaires, taux d'erreur, etc.}
                           function    getHTMLResults(): string;
                           {calculer le taux d'erreur brut}
                           function    getErrorRate(): double;
                           {ajouter le contenu d'une autre matrice de confusion}
                           procedure   addOtherConfMatrix(prmSource: TConfusionMatrix);
                           {tableau crois}
                           property    CrossTab: TCrossTab read FCrossTab;
                           {attribut de prdiction}
                           property    PredAttribute: TAttribute read FPredAttribute;
                           end;

        {composant de base MetaSpvLearning, il est enchan dans
        le diagramme, il reoit un TMLCompSpvLearning}
        TMLCompMetaSpvLearning = class(TMLCompLocalData)
                                 private
                                 {le composant embedded}
                                 FMLSpvL: TMLCompSpvLearning;
                                 {menu de paramtrage du supervised}
                                 FMenuPrmSpv: TMenuItem;
                                 {attribut prdit}
                                 FPredClass: TAttribute;
                                 protected
                                 {un nom gnrique pour les attributs produits par la mthode}
                                 function    ShortMLCompName(): string; virtual; abstract;
                                 {rajouter le menu de paramtres du composant supervised}
                                 procedure   InitMenusParameters(); override;
                                 {montrer la fiche de rsultats}
                                 procedure OnMenuView(Sender: TObject); override;
                                 {lancer l'excution}
                                 procedure OnMenuExecute(Sender: TObject); override;
                                 {sauver en plus le composant embdd}
                                 procedure   SaveComponentInfoToStream(prmStream: TStream); override;
                                 {charger et connect l'embdd}
                                 procedure   LoadComponentInfoFromStream(prmStream: TStream); override;
                                 {sauver les infos de l'embedded en plus}
                                 procedure   SaveComponentInfoToINI(prmINI: TMemIniFile); override;
                                 {charger l'emebbed}
                                 procedure   LoadComponentInfoFromINI(prmSection: string; prmINI: TMemIniFile); override;
                                 public
                                 {dtruire}
                                 destructor  destroy; override;
                                 {gestion diffrencie selon connexion  la suite ou embeddage}
                                 function    isConnectable(prmGen: TMLGenComp): boolean; override;
                                 {menu de paramtrage du supervised}
                                 property    MenuPrmSpv: TMenuItem read FMenuPrmSpv;
                                 {la variable prdite}
                                 property    PredClass: TAttribute read FPredClass write FPredClass;
                                 {le composant supervised associ}
                                 property    MLCompSupervised: TMLCompSpvLearning read FMLSpvL;
                                 end;

        {oprateur mta supervised}
        TOpMetaSpvLearning = class(TOpLocalData)
                             private
                             {oprateur de l'embedded}
                             FOpMLSpv: TOpSpvLearning;
                             {la matrice de confusion associe}
                             FConfusionMatrix: TConfusionMatrix;
                             protected
                             {tableau des probas a posteriori -- utilis pour le calcul des scores}
                             FPostProba: TTabScore;
                             {gestion en plus donc de la matrice de confusion}
                             procedure   ReInitialize(); override;
                             {execution}
                             function    CoreExecute(): boolean; override;
                             {lancer l'apprentissage, modifi selon la classe mta, surcharge obligatoire}
                             procedure   RunLearning(); virtual; abstract;
                             {effectuer la projection, on s'en tient uniquement  la classe prdite pour l'instant}
                             procedure   SetProjections(); virtual;
                             {construire la matrice de confusion, a priori cette procdure ne sera jamais surcharge}
                             procedure   CalcConfusionMatrix();
                             {renvoyer les scores d'affectation pour un individu}
                             procedure   resetScore(example: integer; var postProba: TTabScore); virtual; abstract;
                             {classer un individu, response est la classe attribue, postProba corresp. aux probabilits a posteriori d'affectation}
                             procedure   ClassifyExample(example: integer; var response: TTypeDiscrete); virtual; abstract;
                             {dtruire les classifieurs internalement gnrs}
                             procedure   destroyClassifiers(); virtual; abstract;
                             {vrifier le statut des attributs}
                             function    CheckAttributes(): boolean; override;
                             public
                             {renvoyer le score pour un individu, pour une modalit de la variable  prdire}
                             function    getScoreClassValue(example: integer; classValue: TTypeDiscrete): TTypeContinue;
                             {dtruire}
                             destructor  destroy; override;
                             {insrer par dfaut la matrice de confusion}
                             function    getHTMLResultsSummary(): string; override;
                             {pointeur sur l'oprateur meta}
                             property    OpMLSpv: TOpSpvLearning read FOpMLSpv write FOpMLSpv;
                             end;

        {paramtre oprateur mta supervised}
        TOpPrmMetaSpvLearning = class(TOperatorParameter)
                                protected
                                {pas de bote de dialogue de paramtrage au dpart}
                                function    CreateDlgParameters(): TForm; override;
                                {pas de paramtres par dfaut}
                                procedure   SetDefaultParameters(); override;
                                end;

        {le gnrateur de composnat supervised}
        TMLGenCompSpvLearning = class(TMLGenComp)
                                protected
                                procedure   GenCompInitializations(); override;
                                end;

        {le composant supervised learning}
        TMLCompSpvLearning = class(TMLComponent)
                             private
                             FMetaSpvL: TMLCompMetaSpvLearning;
                             protected
                             {tout le noeud de l'affaire est ici, il faut embedder le composant,
                             le paramtre prmPred indique donc celui dans lequel on veut l'insrer}
                             procedure   InsertIntoDiagram(prmDiagram: TMLDiagram; prmPred: TMLComponent); override;
                             procedure   InitializationsAfterInsertion(); override;
                             {rien en sortie ici}
                             procedure   RefreshOutput(); override;
                             {gestion du paramtrage}
                             procedure   OnMenuParameters(Sender: TObject); override;
                             {desc pour le fichier log}
                             function  GetLogResultDescription(): string; override;
                             public
                             {le message est transmis et non plus affich directement}
                             procedure   SendUserMessage(prmStr: string); override;
                             {section INI dans le fichier de sauvegarde}
                             function    sectionINI(): string; override;
                             {le meta associ}
                             property    MetaSpvL: TMLCompMetaSpvLearning read FMetaSpvL;
                             end;

        {l'oprateur de supervised learning, il n'est jamais excut lui mme,
        son seul rle est de grer la configuration et de passer les paramtres}
        TOpSpvLearning = class(TOperator)
                         private
                         {variable classe  prdire}
                         FClassAtt: TAttribute;
                         protected
                         {liste de toutes les variables}
                         FAllAttributes: TLstAttributes;                         
                         {liste des descripteurs}
                         FDescriptorsAtt: TLstAttributes;
                         {connecter la classe, ne sera jamais modifi sauf si l'on veut une classe forcment binaire (cf. logistic ou SVM)}
                         function ConnectClassAtt(prmData: TMLDataset): boolean; virtual;
                         {connecter les descripteurs, sera modif selon les attributs accepts par la mthode,
                         pour l'instant on les accepte tous pourvu qu'il y en ait 1 au moins}
                         function ConnectDescriptors(prmData: TMLDataset): boolean; virtual;
                         {produit la classe d'apprentissage}
                         function getClassSpvLearning(): TClassCalcSpvLearning; virtual; abstract;
                         public
                         {produit un objet (une instance) apprentissage}
                         function getInstanceSpvLearning(): TCalcSpvLearning;
                         {connecter les attributs en vrifiant l'intgrit}
                         function ConnectAttributes(prmData: TMLDataset): boolean;
                         {l'endogne}
                         property ClassAttribute: TAttribute read FClassAtt;
                         {les exognes}
                         property Descriptors: TLstAttributes read FDescriptorsAtt;
                         end;

        {oprateur spcialis dans les exognes discrets}
        TOpSpvLearningDiscrete = class(TOpSpvLearning)
                                 protected
                                 function ConnectDescriptors(prmData: TMLDataset): boolean; override;
                                 end;

        {oprateur spcialis dans les exognes continues}
        TOpSpvLearningContinuous = class(TOpSpvLearning)
                                   protected
                                   function ConnectDescriptors(prmData: TMLDataset): boolean; override;     
                                   end;     
        

        {paramtrage de l'oprateur}
        TOpPrmSpvLearning = class(TOperatorParameter)
                            protected
                            {pas de bote de dialogue de paramtrage au dpart}
                            function    CreateDlgParameters(): TForm; override;
                            {pas de paramtres par dfaut}
                            procedure   SetDefaultParameters(); override;
                            end;

        {classe de calcul apprentissage supervis}
        TCalcSpvLearning = class(TObject)
                           private
                           {le paramtre de l'algo de calcul}
                           FOpPrmSpv: TOpPrmSpvLearning;
                           {attribut  prdire}
                           FClassAtt: TAttribute;
                           {descripteurs}
                           FDescriptors: TLstAttributes;
                           {statistiques sur l'attribut  prdire}
                           FStatClassAtt: TCalcStatDesDiscrete;
                           {gnrateur de nombre alatoire}
                           FRndGenSpv: TRndGenerator;
                           {tableau temporaire des probas d'affectation}
                           FTabProbaScore: TTabScore;
                           protected
                           {tous les attributs}
                           FAllAttributes: TLstAttributes;
                           {crer les structures de calculs et autres champs globaux (ex. matrices, etc.),  surcharger ventuellement}
                           procedure   createStructures(); virtual;
                           {dtruire les structures de calculs, idem  surcharger ventuellement}
                           procedure   destroyStructures(); virtual;
                           {prparer l'apprentissage, cela permet entre autres d'effectuer des vrifications (ex. matrices non inversibles etc.)}
                           function    beforeLearning(examples: TExamples): boolean; virtual;
                           {lancer l'apprentissage}
                           function    coreLearning(examples: TExamples): boolean; virtual; abstract;
                           {mettre  jour les ventuels indicateurs}
                           function    afterLearning(examples: TExamples): boolean; virtual;
                           public
                           {rcupration des donnes et des paramtres de l'apprentissage}
                           constructor create(prmOpSpv: TOpPrmSpvLearning; prmClass: TAttribute; prmDescriptors: TLstAttributes; prmAllAttributes: TLstAttributes); virtual;
                           {apprentissage}
                           function    learning(examples: TExamples): boolean;
                           {destructeur avec destruction des structures}
                           destructor  destroy; override;
                           {calculer les probas d'affectation pour un exemple}
                           procedure   getScore(example: integer; var postProba: TTabScore); virtual; abstract;
                           {classer un exemple}
                           procedure   classification(example: integer; var response: TTypeDiscrete); virtual;
                           {envoyer une description HTML des rsultats}
                           function    getHTMLResults(): string; virtual;
                           {le provider d'instances et de proprits}
                           property    OpPrmSpv: TOpPrmSpvLearning read FOpPrmSpv;
                           {attribut  prdire}
                           property    ClassAttribute: TAttribute read FClassAtt;
                           {descripteurs}
                           property    Descriptors: TLstAttributes read FDescriptors;
                           {stat sur l'attribut classe}
                           property    StatClassAtt: TCalcStatDesDiscrete read FStatClassAtt;
                           {gnrateur de nombre alatoire de la classe}
                           property    RndGenSpv: TRndGenerator read FRndGenSpv;
                           end;


implementation

uses
        Sysutils, Windows,
        ULogFile, UConstConfiguration, UPaletteGenCompDefinition,
  UCompDataset;

{ TOpSpvLearning }

function TOpSpvLearning.ConnectAttributes(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 FAllAttributes:= prmData.LstAtts[asAll];
 ok:= self.ConnectClassAtt(prmData);
 if ok
  then ok:= self.ConnectDescriptors(prmData);
 result:= ok;
end;

function TOpSpvLearning.ConnectClassAtt(prmData: TMLDataset): boolean;
var ok: boolean;
    att: TAttribute;
begin
 ok:= (prmData.LstAtts[asTarget].Count = 1);
 if ok
  then
   begin
    att:= prmData.LstAtts[asTarget].Attribute[0];
    ok:= att.isCategory(caDiscrete);
    TraceLog.WriteToLogFile('TOpSpvLearning.ConnectClassAtt, instance delphi de : '+self.ClassName);
    TraceLog.WriteToLogFile('TOpSpvLearning.ConnectClassAtt, nom de class attribute : '+att.Name);
    if ok
     then FClassAtt:= att;
   end;
 result:= ok;
end;

function TOpSpvLearning.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
begin
 ok:= (prmData.LstAtts[asInput].Count>0);
 if ok
  //branchement direct, pas de recopie locale, s'il y a une slection de variables  faire
  //elle doit tre ralise avant ce composant
  then FDescriptorsAtt:= prmData.LstAtts[asInput];
 result:= ok;
end;

function TOpSpvLearning.getInstanceSpvLearning: TCalcSpvLearning;
begin
 result:= self.getClassSpvLearning.create(self.PrmOp as TOpPrmSpvLearning,ClassAttribute,Descriptors,FAllAttributes);
end;

{ TCalcSpvLearning }

function TCalcSpvLearning.afterLearning(examples: TExamples): boolean;
begin
 result:= true;
end;

function TCalcSpvLearning.beforeLearning(examples: TExamples): boolean;
begin
 result:= true;
 try
 if assigned(FStatClassAtt) then FStatClassAtt.Free();
 FStatClassAtt:= TCalcStatDesDiscrete.Create(FClassAtt,examples);
 except
 result:= false;
 end;
end;

procedure TCalcSpvLearning.classification(example: integer;
  var response: TTypeDiscrete);
begin
 //calculer les probas d'affectation
 self.getScore(example,FTabProbaScore);
 //dterminer la rponse
 //response:= FTabProbaScore.getIndexMax();

 //****************************************************
 //new -- 24/04/2005 --  voir -- Much complicated,  voir vraiment si c'est ncessaire
 //au moins on a la garantie d'avoir une rponse !
 //****************************************************
 
 //normaliser
 FTabProbaScore.normalize();
 //vrifier qu'il y a bien une conclusion possible
 if (FTabProbaScore[0] > 0)
  //rcuprer l'index. de celui qui maximise le score
  then response:= FTabProbaScore.getIndexMax()
  //ou bien prendre le classifieur par dfaut
  else response:= FStatClassAtt.TabFreq.getIndexMaxValue();
end;

constructor TCalcSpvLearning.create(prmOpSpv: TOpPrmSpvLearning; prmClass: TAttribute; prmDescriptors: TLstAttributes; prmAllAttributes: TLstAttributes);
begin
 inherited Create();
 FOpPrmSpv:= prmOpSpv;
 FClassAtt:= prmClass;
 FDescriptors:= prmDescriptors;
 FAllAttributes:= prmAllAttributes;
 //-- dangerous -- utilisation d'un gnrateur alatoire pour les calculs
 //!\ bien rflechir  cette affaire quand mme //!\
 //**********************************************************************
 FRndGenSpv:= TRndGenerator.Create(STD_SEED_START,DEFAULT_SEED_VALUE_1,DEFAULT_SEED_VALUE_2);
 //tableau des probas
 FTabProbaScore:= TTabScore.create(FClassAtt);
 self.createStructures();
end;

procedure TCalcSpvLearning.createStructures;
begin
 //nothing
end;

destructor TCalcSpvLearning.destroy;
begin
 FTabProbaScore.Free();
 FRndGenSpv.Free();
 if assigned(FStatClassAtt)
  then FreeAndNil(FStatClassAtt);
 self.destroyStructures();
 inherited Destroy;
end;

procedure TCalcSpvLearning.destroyStructures;
begin
 //nothing
end;

function TCalcSpvLearning.getHTMLResults: string;
begin
 result:= '<H3>'+self.ClassName+'</H3>';
end;

function TCalcSpvLearning.learning(examples: TExamples): boolean;
var ok: boolean;
begin
 ok:= self.beforeLearning(examples);
 ok:= ok and self.coreLearning(examples);
 ok:= ok and self.afterLearning(examples);
 result:= ok;
end;

{ TOpPrmMetaSpvLearning }

function TOpPrmMetaSpvLearning.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmMetaSpvLearning.SetDefaultParameters;
begin
 //pas de paramtres par dfaut au dpart
end;

{ TMLCompMetaSpvLearning }

destructor TMLCompMetaSpvLearning.destroy;
begin
 //se dtruire
 inherited destroy;
 //dtruire le composant apprentissage supervis embdd
 if assigned(FMLSpvL)
  then FMLSpvL.Free; 
end;

procedure TMLCompMetaSpvLearning.InitMenusParameters;
begin
 inherited InitMenusParameters();
 //menu parameters
 FMenuPrmSpv:= TMenuItem.Create(PopMenu);
 FMenuPrmSpv.Caption:= 'Supervised parameters...';
 FMenuPrmSpv.Enabled:= FALSE;
 FMenuPrmSpv.OnClick:= NIL;// initaliser  la connexion
 PopMenu.Items.Add(FMenuPrmSpv);
end;

function TMLCompMetaSpvLearning.isConnectable(prmGen: TMLGenComp): boolean;
begin
 //on accepte tout mais on traitera diffremment les supervised
 if (prmGen.MLComp <> mlcSpvLearning)
  then result:= TRUE
  //si la place est occupe, on n'accepte pas bien sr
  else result:= not(assigned(FMLSpvL));
end;

procedure TMLCompMetaSpvLearning.LoadComponentInfoFromINI(
  prmSection: string; prmINI: TMemIniFile);
var ok: boolean;
    //id: integer;
    mlGen: TMLGenComp;
    comp: TMLComponent;
    eSection: string;
    sClassGen: shortstring;
begin
 ok:= prmINI.ReadBool(prmSection,'embedded_spv',FALSE);
 if ok
  then
   begin
    eSection:= prmINI.ReadString(prmSection,'embedded_section','');
    if (eSection<>'')
     then
      begin
       //id:= prmINI.ReadInteger(eSection,'icon',0);
       //mlGen:= globalLstGenComp.getGenComp(id);
       sClassGen:= prmINI.ReadString(eSection,'MLClassGenerator',DATASET_GEN_CLASS_NAME);
       mlGen:= globalLstGenComp.getGenComp(sClassGen);
       comp:= mlGen.GetClassMLComponent.CreateMLComponent(self.Diagram,mlGen,self);
       comp.LoadFromINI(eSection,prmINI);
      end;
   end;
end;

procedure TMLCompMetaSpvLearning.LoadComponentInfoFromStream(
  prmStream: TStream);
var ok: boolean;
    //id: integer;
    mlGen: TMLGenComp;
    comp: TMLComponent;
    sClassGen: shortstring;
begin
 prmStream.ReadBuffer(ok,sizeof(ok));
 if ok
  then
   begin
    //rcuprer le n d'icne, mme mcanisme que dans le diagramme
    //prmStream.ReadBuffer(id,sizeof(id));
    prmStream.ReadBuffer(sClassGen,sizeof(sClassGen));
    //rcuprer le gnrateur de composant associ
    //mlGen:= globalLstGenComp.getGenComp(id);
    mlGen:= globalLstGenComp.getGenComp(sClassGen);
    //insrer dans le diagramme
    comp:= mlGen.GetClassMLComponent.CreateMLComponent(self.Diagram,mlGen,self);
    //les infos de l'ago embdd le cas chant
    comp.LoadFromStream(prmStream);
   end;
end;

procedure TMLCompMetaSpvLearning.OnMenuExecute(Sender: TObject);
begin
 if assigned(FMLSpvL)
  then inherited OnMenuExecute(Sender)
  else self.SendUserMessage('connect a supervised learning before');
end;

procedure TMLCompMetaSpvLearning.OnMenuView(Sender: TObject);
begin
 if assigned(FMLSpvL)
  then inherited OnMenuView(Sender)
  else self.SendUserMessage('connect a supervised learning before');
end;

procedure TMLCompMetaSpvLearning.SaveComponentInfoToINI(
  prmINI: TMemIniFile);
var ok: boolean;
begin
 ok:= assigned(FMLSpvL);
 prmINI.WriteBool(self.sectionINI(),'embedded_spv',ok);
 if ok
  then
   begin
    prmINI.WriteString(self.sectionINI(),'embedded_section',FMLSpvL.sectionINI());
    FMLSpvL.SaveToIniFile(prmINI);
   end;
end;

procedure TMLCompMetaSpvLearning.SaveComponentInfoToStream(
  prmStream: TStream);
var ok: boolean;
begin
 ok:= assigned(FMLSpvL);
 prmStream.WriteBuffer(ok,sizeof(ok));
 if ok
  then
   begin
    FMLSpvL.SaveToStream(prmStream);
   end;
end;

{ TOpPrmSpvLearning }

function TOpPrmSpvLearning.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmSpvLearning.SetDefaultParameters;
begin
 //nothing
end;

{ TMLCompSpvLearning }

function TMLCompSpvLearning.GetLogResultDescription: string;
begin
 result:= format('one instance of %s generated',[self.ClassName]);
end;

procedure TMLCompSpvLearning.InitializationsAfterInsertion;
begin
 inherited InitializationsAfterInsertion();
 //ici seulement on peut rcuprer l'oprateur
 (FMetaSpvL.Operator as TOpMetaSpvLearning).OpMLSpv:= self.Operator as TOpSpvLearning;
end;

procedure TMLCompSpvLearning.InsertIntoDiagram(prmDiagram: TMLDiagram;
  prmPred: TMLComponent);
begin
 //le test de connectable a dj assur le coup, pas de pbm de cast a priori
 FMetaSpvL:= prmPred as TMLCompMetaSpvLearning;
 FMetaSpvL.FMLSpvL:= self;
  //puis assurer l'affichage
 FMetaSpvL.NumIconState:= self.FNumIcon;
 //FMetaSpvL.TvNode.StateIndex:= self.FNumIcon;
 FMetaSpvl.AddInfosDescription(self.Description);
 FMetaSpvL.MenuPrmSpv.Enabled:= TRUE;
 FMetaSpvL.MenuPrmSpv.OnClick:= OnMenuParameters;//toute l'astuce est ici...
 //rcuprer le diagramme
 self.Diagram:= prmDiagram;
 //rafachir l'affichage car gestion des state image un peu bizarre
 prmDiagram.TreeView.Refresh;
 //vrif
 //TraceLog.WriteToLogFile('icon : '+IntToStr(FMetaSpvl.TvNode.ImageIndex)+', state icon : '+IntToStr(FMetaSpvl.TvNode.StateIndex));
 //TraceLog.WriteToLogFile(FMetaSpvL.Diagram.TreeView.Images.Name+'<?>'+FMetaSpvL.Diagram.TreeView.StateImages.Name);
end;

procedure TMLCompSpvLearning.OnMenuParameters(Sender: TObject);
begin
 //fermer la fiche de visualisation du contenant au cas o elle serait ouverte
 if assigned(FMetaSpvL.Operator)
  then FMetaSpvL.Operator.ReleaseForm();
 //ok, on peut montrer, si modif des paramtres, tous les composants successeurs sont invalids
 if self.Operator.PrmOp.AskParameter()
  //celui du contenant est invalid
  then
   begin
    self.Invalidate();
    FMetaSpvL.Invalidate();
   end;
 //new -- 18/06/2005 -- rafrachir l'tat visuel des composants
 if (self.Diagram <> nil)
 then self.Diagram.TreeView.Refresh();
end;

procedure TMLCompSpvLearning.RefreshOutput;
begin
 //nothing
end;

function TMLCompSpvLearning.sectionINI: string;
begin
 //FMetaSpvL est toujours assign ? erreur sinon...
 //on garantit l'unicit des sections avec ce procd, il y pbm sinon
 result:= self.FMetaSpvL.sectionINI()+'--'+inherited sectionINI();
end;

procedure TMLCompSpvLearning.SendUserMessage(prmStr: string);
begin
 FMetaSpvL.SendUserMessage(prmStr);
end;

{ TOpMetaSpvLearning }

procedure TOpMetaSpvLearning.CalcConfusionMatrix;
begin
 if assigned(FConfusionMatrix)
  then FConfusionMatrix.Free;
 //cration et calcul  la vole
 FConfusionMatrix:= TConfusionMatrix.create(OpMLSpv.ClassAttribute,(MLOwner as TMLCompMetaSpvLearning).PredClass,workdata.Examples);
end;

function TOpMetaSpvLearning.CheckAttributes: boolean;
begin
 //vrifier que l'oprateur est capable de fonctionner avec ces variables
 result:= self.FOpMLSpv.ConnectAttributes(workdata);
end;

function TOpMetaSpvLearning.CoreExecute: boolean;
var duration: cardinal;
begin
 result:= true;
 TRY
 //prparer le tableau interne des probas a posteriori
 if assigned(FPostProba) then FPostProba.Free();
 FPostProba:= TTabScore.create(OpMLSpv.ClassAttribute);
 //compteur de dure
 duration:= GetTickCount();
 //lancer l'apprentissage, i.e. dans la mme foule, la cration des instances et l'excution de l'apprentissage sur les donnes
 self.RunLearning();
 duration:= GetTickCount()-duration;
 TraceLog.WriteToLogFile(Format('<>>> run learning duration (%s) : %d',[self.ClassName,duration]));
 //effectuer les projections adquates, au moins la variable prdite
 duration:= GetTickCount();
 self.SetProjections();
 duration:= GetTickCount()-duration;
 TraceLog.WriteToLogFile(Format('<>>> set projection duration (%s) : %d',[self.ClassName,duration]));
 //construire la matrice de confusion, aprs les projections bien entendu !!!
 self.CalcConfusionMatrix();
 EXCEPT
 result:= FALSE;
 END;
end;

destructor TOpMetaSpvLearning.destroy;
begin
 if assigned(FPostProba) then FPostProba.Free();
 inherited destroy;
 self.destroyClassifiers(); 
end;

function TOpMetaSpvLearning.getHTMLResultsSummary: string;
var s: string;
begin
 s:= '<P><H2>Classifier performances</H2>'+FConfusionMatrix.getHTMLResults()+'<HR>';
 s:= s+'<P><H2>Classifier characteristics</H2>';
 //new -- 23/05/2005 -- description du problme
 s:= s+'<h3>Data description</h3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<th>Target attribute</th><td>%s (%d values)</td></tr>',[FOpMLSpv.ClassAttribute.Name,FOpMLSpv.ClassAttribute.NbValues]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<th># descriptors</th><td>%d</td></tr>',[FOpMLSpv.Descriptors.Count]);
 s:= s+'</table>';
 //
 result:= s;
end;

function TOpMetaSpvLearning.getScoreClassValue(example: integer;
  classValue: TTypeDiscrete): TTypeContinue;
begin
 //recalculer les scores de l'exemple
 self.resetScore(example,FPostProba);
 //normaliser au cas o
 FPostProba.normalize();
 //renvoyer la valeur pour la classe demande
 result:= FPostProba.getValue(classValue);
end;

procedure TOpMetaSpvLearning.ReInitialize;
begin
 inherited ReInitialize();
 if assigned(FConfusionMatrix)
  then FreeAndNil(FConfusionMatrix);
end;

procedure TOpMetaSpvLearning.SetProjections();
var pred: TAttribute;
    i: integer;
    response: TTypeDiscrete;
begin
 self.GenAtts.Clear;//PredClass a t gicl puisqu'il est dans la liste et qu'il appartient  la liste
 //pas de dtruire donc
 (*
 if assigned((self.MLOwner as TMLCompMetaSpvLearning).PredClass)
  then (self.MLOwner as TMLCompMetaSpvLearning).PredClass.Free;
 *)
 //reconstruire
 pred:= TAttDiscrete.Create(format('pred_%s_%d',[(MLOwner as TMLCompMetaSpvLearning).ShortMLCompName(),(MLOwner as TMLCompMetaSpvLearning).Number]),WorkData.LstAtts[asTarget].Size);
 (self.MLOwner as TMLCompMetaSpvLearning).PredClass:= pred;
 pred.LstValues.assign(OpMLSpv.ClassAttribute.LstValues);//si on en est l c'est toutes les vrifications ont t effectues
 //pour chaque individu
 for i:= 1 to pred.Size do
  begin
   self.ClassifyExample(i,response);
   pred.dValue[i]:= response;
  end;
 //ajouter pour exportation
 GenAtts.Add(pred);
end;

{ TOpSpvLearningDiscrete }

function TOpSpvLearningDiscrete.ConnectDescriptors(prmData: TMLDataset): boolean;
var ok: boolean;
    att: TAttribute;
    i: integer;
begin
 ok:= (prmData.LstAtts[asInput].Count>0);
 if ok
  then
   begin
    for i:= 0 to pred(prmData.LstAtts[asInput].Count) do
     begin
      att:= prmData.LstAtts[asInput].Attribute[i];
      ok:= ok and att.isCategory(caDiscrete);
     end;
    if ok
     then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
   end;
 result:= ok;
end;

{ TOpSpvLearningContinuous }

function TOpSpvLearningContinuous.ConnectDescriptors(
  prmData: TMLDataset): boolean;
var ok: boolean;
    att: TAttribute;
    i: integer;
begin
 ok:= (prmData.LstAtts[asInput].Count>0);
 if ok
  then
   begin
    for i:= 0 to pred(prmData.LstAtts[asInput].Count) do
     begin
      att:= prmData.LstAtts[asInput].Attribute[i];
      ok:= ok and att.isCategory(caContinue);
     end;
    if ok
     then FDescriptorsAtt:= prmData.LstAtts[asInput];//branchement direct, pas de recopie locale
   end;
 result:= ok;
end;

{ TConfusionMatrix }

procedure TConfusionMatrix.addOtherConfMatrix(prmSource: TConfusionMatrix);
var i,j: integer;
begin
 for i:= 0 to FCrossTab.RowCount do
  for j:= 0 to FCrossTab.ColCount do
   FCrossTab.Value[i,j]:= FCrossTab.Value[i,j]+prmSource.CrossTab.Value[i,j];
end;

function TConfusionMatrix.connectPredAttribute(
  attPred: TAttribute): boolean;
begin
 //tester le nombre de colonnes
 if (attPred.nbValues=self.FCrossTab.RowCount)
  then
   begin
    //new -- 18/07/2005 -- rafrachir galement l'info sur l'attribut de prdiction
    FPredAttribute:= attPred;
    //
    self.FCrossTab.connectNewAttributes(self.FClassAttribute,attPred);
    result:= TRUE;
   end
  else result:= FALSE;
end;

constructor TConfusionMatrix.create(prmClassAtt, prmPredAtt: TAttribute;
  prmExamples: TExamples);
begin
 inherited Create();
 //connecter les variables
 FClassAttribute:= prmClassAtt;
 FPredAttribute:= prmPredAtt;
 //construire au moins la structure du tableau crois
 FCrossTab:= TCrossTab.create(prmClassAtt,prmPredAtt);
 if assigned(prmExamples)
  then refresh(prmExamples);
end;

constructor TConfusionMatrix.createStructure(prmClassAtt: TAttribute);
begin
 inherited Create();
 //connecter la classe, (new -- 18/07/2005 -- l'attribut de prdiction reste  NIL ici !!!)
 FClassAttribute:= prmClassAtt;
 //pour avoir un tableau crois valide
 FCrossTab:= TCrossTab.create(prmClassAtt,prmClassAtt);
end;

destructor TConfusionMatrix.destroy;
begin
  FCrossTab.Free;
  inherited;
end;

function TConfusionMatrix.getACcuracy(k: integer): double;
begin
 result:= 0.0;
 if (FCrossTab.Value[0,k]>0)
  then result:= FCrossTab.ColFreq[k,k];
end;

function TConfusionMatrix.getErrorRate: double;
var k: integer;
    s: double;    
begin
 //pour assurer le coup
 result:= 1.0;
 //calcul effectif
 s:= 0.0;
 for k:= 1 to FCrossTab.RowCount do
  s:= s+FCrossTab.Value[k,k];
 //envoyer
 if (FCrossTab.Value[0,0]>0)
  then result:= 1.0-s/(1.0*FCrossTab.Value[0,0]);
end;

function TConfusionMatrix.getHTMLResults: string;
var s: string;
    k: integer;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GREEN+format('<TH>%s</TH><TD align=center>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD></TR>',['Error rate',self.getErrorRate()]);
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+format('<TH>%s</TH><TH>%s</TH></TR>',['Values prediction','Confusion matrix']);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+'<TD valign=top>';
 s:= s+HTML_HEADER_TABLE_RESULT+
     HTML_TABLE_COLOR_HEADER_BLUE+'<TH>Value</TH><TH>Recall</TH><TH>1-Precision</TH></TR>';
 for k:= 1 to FCrossTab.RowCount do
  begin
   s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TH>%s</TH><TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD><TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD></TR>',
                                     [FClassAttribute.LstValues.GetDescription(k),self.getSensibility(k),1.0-self.GetAccuracy(k)]);
  end;
 s:= s+'</table></TD><TD>';
 s:= s+FCrossTab.getHTMLResult(-1,'');
 s:= s+'</TD></TR>';
 s:= s+'</table>';
 result:= s;
end;

function TConfusionMatrix.getSensibility(k: integer): double;
begin
 result:= 0.0;
 if (FCrossTab.Value[k,0]>0)
  then result:= FCrossTab.RowFreq[k,k]; 
end;

procedure TConfusionMatrix.refresh(prmExamples: TExamples);
begin
 FCrossTab.Refresh(prmExamples);
end;

{ TMLGenCompSpvLearning }

procedure TMLGenCompSpvLearning.GenCompInitializations;
begin
  FMLComp:= mlcSpvLearning;
end;

end.
