(******************************************************************)
(* UCompManageDataset.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Composant gnrique grant localement un ensemble de donnes)
@author(Ricco)
@created(12/01/2004)
Ce composant gnrique est l'anctre des composants : (1) qui ont produit des donnes localement,
(2) qui exportent  l'extrieur un nouvel ensemble de donnes.
Remarque : Certains composants ne gnrent rien et se contentent d'exporter des donnes.
}
unit UCompManageDataset;

interface

USES
        UCompDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation;

TYPE
        {Composant avec gestion de var. locales et exportation de donnes}
        TMLCompLocalData = class(TMLComponent)
                           protected
                           {l'ensemble de donnes localement gnr}
                           FLocalDataset: TLstAttributes;
                           {l'ensemble de donnes propos en sortie}
                           FOutputMLData: TMLDataset;
                           {initialisation des ensembles de donnes}
                           procedure  InitializeDataset(); virtual;
                           {surcharge de l'initialisation pour grer les donnes}
                           procedure  InitializationsAfterInsertion(); override;
                           {rcuprer l'input et ajouter les donnes locales}
                           procedure  RefreshOutput(); override;
                           {ajouter les attributs crs localement}
                           procedure  AddLocalAttributes(); virtual;
                           public
                           {dtruire les objets locaux}
                           destructor Destroy; override;
                           {ensemble de donnes en sortie}
                           property   OutputData: TMLDataset read FOutputMLData;
                           {les attributs locaux}
                           property   LocalDataset: TLstAttributes read FLocalDataset;
                           end;

        {Oprateur grant les donnes locales}
        TOpLocalData = class(TOperator)
                       private
                       {donnes sur lesquelles on travaille}
                       FWorkData: TMLDataset;
                       {les attributs gnrs}
                       FGenAtts: TLstAttributes;
                       {donnes en sortie}
                       FOutputData: TMLDataset;
                       protected
                       function   CheckExamples(): boolean; override;
                       public
                       {rcupration des donnes de travail, les donnes en entre}
                       constructor Create(AOwner: TObject); override;
                       {les donnes de travail}
                       property    WorkData: TMLDataset read FWorkData;
                       property    GenAtts: TLstAttributes read FGenAtts;
                       property    OutputData: TMLDataset read FOutputData;
                       end;

implementation

{ TMLCompLocalData }

destructor TMLCompLocalData.Destroy;
begin
  if assigned(FLocalDataset)
   then FLocalDataset.Free;
  inherited Destroy;
end;

procedure TMLCompLocalData.InitializationsAfterInsertion();
begin
 //gnrer l'ensemble de donnes locales et les donnes en sortie
 self.InitializeDataset();
 //puis crer entre autres l'oprateur associ
 inherited InitializationsAfterInsertion();
end;

procedure TMLCompLocalData.InitializeDataset();
begin
 //l'ensemble en sortie
 if assigned(self.Predecessor) and self.Predecessor.InheritsFrom(TMLCompLocalData)
  then FOutPutMLData:= TMLDataset.CreateFromMLDataset((self.Predecessor as TMLCompLocalData).OutputData);
 if assigned(FOutputMLData)
  //propritaire des donnes !!!
  then FLocalDataset:= TLstAttributes.Create(TRUE,FOutputMLData.LstAtts[asAll].Size)
  else FLocalDataset:= TLstAttributes.Create(TRUE,0);
end;

procedure TMLCompLocalData.RefreshOutput;
begin
 //rcuprer l'entre tout btement, et ajouter les variables locales
 if assigned(self.Predecessor) and self.Predecessor.InheritsFrom(TMLCompLocalData)
  then
   begin
    FOutputMLData.Copy((self.Predecessor as TMLCompLocalData).OutputData);
    self.AddLocalAttributes();
   end;
end;

procedure TMLCompLocalData.AddLocalAttributes;
var i: integer;
    att: TAttribute;    
begin
 //ajout global
 for i:= 0 to pred(LocalDataset.Count) do
  begin
   att:= LocalDataset.Attribute[i];
   outputData.LstAtts[asAll].Add(att);
  end;
end;

{ TOpLocalData }

function TOpLocalData.CheckExamples: boolean;
begin
 result:= (self.WorkData.Examples.Size > 0);
end;

constructor TOpLocalData.Create(AOwner: TObject);
begin
 //brancher le pointeur sur les donnes
 if assigned((AOwner as TMLCompLocalData).Predecessor)
  then FWorkData:= ((AOwner as TMLCompLocalData).Predecessor as TMLCompLocalData).OutputData;
 //rcuprer les attributs gnrs localement
 if assigned((AOwner as TMLCompLocalData).LocalDataset)
  then FGenAtts:= (AOwner as TMLCompLocalData).LocalDataset;
 //rcuprer le pointeur sur les donnes en sortie
 if assigned((AOwner as TMLCompLocalData).OutputData)
  then FOutputData:= (AOwner as TMLCompLocalData).OutputData;
 //construction par dfaut par la suite
 inherited Create(AOwner);
end;

end.
