(***************************************************************************)
(* UCompViewCorrelationScatter.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************************)

{
@abstract(Cercle des corrlations)
@author(Ricco)
@created(12/01/2004)
Trs utile pour une analyse factorielle, mais galement pour tout autre reprsentation.
}
unit UCompViewCorrelationScatter;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCalcStatDesCorrelation;        

TYPE

        {Gnrateur de composant de visualisation}
        TMLGenCompCorrelationScatter = class(TMLGenComp)
                                       protected
                                       procedure   GenCompInitializations(); override;
                                       public
                                       function    GetClassMLComponent: TClassMLComponent; override;
                                       end;

        {le composant de visualisation}
        TMLCompCorrelationScatter = class(TMLCompLocalData)
                                    protected
                                    function    getClassOperator: TClassOperator; override;
                                    end;

        {l'oprateur de visualisation}
        TOpCorrelationScatter = class(TOpLocalData)
                                 private
                                 {attribut X1}
                                 FX1: TAttribute;
                                 {attribut X2}
                                 FX2: TAttribute;
                                 {liste de stats correlation pour la variable X1}
                                 FLstX1: TLstCalcSDCorrelation;
                                 {idem pour X2}
                                 FLstX2: TLstCalcSDCorrelation; 
                                 protected
                                 function    getClassParameter: TClassOperatorParameter; override;
                                 function    getNewForm(): TForm; override;
                                 {initialiser les stats descriptives conditionnelles}
                                 procedure   InitializeStatDesCorrelation();
                                 {vider les listes conditionnelles}
                                 procedure   ClearLists();
                                 {crer les statistiques adquates: X1 et X2 sont dans les Target, les caractrisantes sont dans les Input}
                                 procedure   BuildLists();
                                 {reconstruire les stats descriptives ici}
                                 function    CoreExecute(): boolean; override;
                                 {statut des attributs}
                                 function    CheckAttributes(): boolean; override;
                                 public
                                 constructor Create(AOwner: TObject); override;
                                 destructor  Destroy; override;
                                 {variable X1}
                                 property    X1: TAttribute read FX1;
                                 {variable X2}
                                 property    X2: TAttribute read FX2;
                                 {liste de stats sur X1}
                                 property    LstX1: TLstCalcSDCorrelation read FLstX1;
                                 {liste de stats sur X2}
                                 property    LstX2: TLstCalcSDCorrelation read FLstX2;
                                 end;

        {paramtrage de l'oprateur de visualisation}
        TOpPrmCorrelationScatter = class(TOperatorParameter)
                                   protected
                                   procedure   SetDefaultParameters(); override;
                                   function    CreateDlgParameters(): TForm; override;
                                   end;



implementation

uses
        Classes,
        UFrmOpViewCorrelationScatterplot, UStringsResources;

{ TMLGenCompCorrelationScatter }

procedure TMLGenCompCorrelationScatter.GenCompInitializations;
begin
 FMLComp:= mlcDataView;
 //FMLNumIcon:= 21;
 //FMLCompName:= str_comp_name_view_corr_scatter;
 //FMLBitmapFileName:= 'MLViewCorrelationScatter.bmp';
end;

function TMLGenCompCorrelationScatter.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompCorrelationScatter;
end;

{ TMLCompCorrelationScatter }

function TMLCompCorrelationScatter.getClassOperator: TClassOperator;
begin
 result:= TOpCorrelationScatter;
end;

{ TOpCorrelationScatter }

procedure TOpCorrelationScatter.BuildLists;
var statX1,statX2: TCalcSDCorrelation;
    y: TAttribute;
    i: integer;
begin
 self.ClearLists();
 //sinon, on ne fait rien
 if (workdata.LstAtts[asTarget].Count=2)
  then
   begin
    FX1:= workdata.LstAtts[asTarget].Attribute[0];
    FX2:= workdata.LstAtts[asTarget].Attribute[1];
    //sinon galement il n'y a rien  faire
    if FX1.isCategory(caContinue) and FX2.isCategory(caContinue)
     then
      begin
       for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
        begin
         y:= workdata.LstAtts[asInput].Attribute[i];
         //sinon, a va pas non plus
         if y.isCategory(caContinue)
          then
           begin
            //cration
            statX1:= TCalcSDCorrelation.Create(FX1,y,workdata.Examples);
            statX2:= TCalcSDCorrelation.Create(FX2,y,workdata.Examples);
            //ajout simultan dans les listes
            FLstX1.AddStat(statX1);
            FLstX2.AddStat(statX2);
           end;
        end;
      end;
   end;
end;

function TOpCorrelationScatter.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= TRUE;
 {$B-}
 //vrification des target
 ok:= ok and (self.WorkData.LstAtts[asTarget].Count = 2) and (self.WorkData.LstAtts[asTarget].isAllCategory(caContinue));
 //vrification des input
 ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
 //and then...
 result:= ok;
end;

procedure TOpCorrelationScatter.ClearLists;
begin
 FLstX1.FreeAll;
 FLstX2.FreeAll;
 FX1:= NIL;
 FX2:= NIL;
end;

function TOpCorrelationScatter.CoreExecute: boolean;
begin
 result:= TRUE;
 TRY
 self.BuildLists();
 EXCEPT
 result:= FALSE;
 END;
end;

constructor TOpCorrelationScatter.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 self.InitializeStatDesCorrelation();
end;

destructor TOpCorrelationScatter.Destroy;
begin
 FLstX1.Free;
 FLstX2.Free;
 inherited;
end;

function TOpCorrelationScatter.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmCorrelationScatter;
end;

function TOpCorrelationScatter.getNewForm: TForm;
begin
 result:= TFrmOpViewCorrelationScatterplot.CreateFromOperator(self);
end;

procedure TOpCorrelationScatter.InitializeStatDesCorrelation;
begin
 FLstX1:= TLstCalcSDCorrelation.Create(nil,nil);
 FLstX2:= TLstCalcSDCorrelation.Create(nil,nil);
end;

{ TOpPrmCorrelationScatter }

function TOpPrmCorrelationScatter.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmCorrelationScatter.SetDefaultParameters;
begin
 //nothing
end;

initialization
 RegisterClass(TMLGenCompCorrelationScatter);
end.
