(*******************************************************************)
(* UDlgOpPrmExportData.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

unit UDlgOpPrmExportData;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, ExtCtrls, CheckLst,
  ComCtrls, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomBrowseEdit, LMDFileSaveEdit;

type
  TDlgOpPrmExportDataset = class(TDlgBaseOperatorParameter)
    rgExamples: TRadioGroup;
    rgAttributes: TRadioGroup;
    Label1: TLabel;
    saveEdit: TLMDFileSaveEdit;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmExportDataset: TDlgOpPrmExportDataset;

implementation

uses UCompExportDataset;

{$R *.dfm}

{ TDlgOpPrmExportDataset }

procedure TDlgOpPrmExportDataset.ApplyModifications;
var prm: TOpPrmExportData;
begin
 prm:= OpPrm as TOpPrmExportData;
 prm.SelectExamples:= self.rgExamples.ItemIndex;
 prm.SelectAttributes:= self.rgAttributes.ItemIndex;
 prm.FileName:= self.saveEdit.Text;
end;

procedure TDlgOpPrmExportDataset.SetParameters;
var prm: TOpPrmExportData;
begin
 prm:= OpPrm as TOpPrmExportData;
 self.rgExamples.ItemIndex:= prm.SelectExamples;
 self.rgAttributes.ItemIndex:= prm.SelectAttributes;
 self.saveEdit.Text:= prm.FileName;
end;

end.
