(****************************************************************)
(* UCompViewDataset.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(Visualisation "brute" des donnes dans une grille)
@author(Ricco)
@created(12/01/2004)
}
unit UCompViewDataset;

interface

USES
        Forms,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetImplementation;

TYPE
        {Gnrateur de composant de visualisation}
        TMLGenCompViewData = class(TMLGenComp)
                             protected
                             procedure   GenCompInitializations(); override;
                             public
                             function    GetClassMLComponent: TClassMLComponent; override;   
                             end;

        {le composant de visualisation}
        TMLCompViewData = class(TMLCompLocalData)
                          protected
                          function    getClassOperator: TClassOperator; override;
                          end;

        {l'oprateur de visualisation}
        TOpViewData = class(TOperator)
                      protected
                      function    getClassParameter: TClassOperatorParameter; override;
                      function    getNewForm(): TForm; override;
                      {pas de lancement de calcul ici}
                      function    CoreExecute(): boolean; override;
                      public
                      end;

        {paramtrage de l'oprateur de visualisation}
        TOpPrmViewData = class(TOperatorParameter)
                         private
                         FViewStatus: TEnumAttStatus; 
                         protected
                         procedure   SetDefaultParameters(); override;
                         function    CreateDlgParameters(): TForm; override;
                         procedure   GetParameters(var prmModif: boolean); override;
                         public
                         property    ViewStatus: TEnumAttStatus read FViewStatus write FViewStatus;
                         end;

implementation

uses
        Classes,
        UDlgOpPrmViewData, UFrmOpViewData, UStringsResources;

{ TMLGenCompViewData }

procedure TMLGenCompViewData.GenCompInitializations;
begin
 FMLComp:= mlcDataView;
 //FMLNumIcon:= 1;
 //FMLCompName:= str_comp_name_view_dataset;
 //FMLBitmapFileName:= 'MLViewDataset.bmp';
end;

function TMLGenCompViewData.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompViewData;
end;

{ TMLCompViewData }

function TMLCompViewData.getClassOperator: TClassOperator;
begin
 result:= TOpViewData;
end;

{ TOpViewData }

function TOpViewData.CoreExecute: boolean;
begin
 result:= TRUE;
end;

function TOpViewData.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmViewData;
end;

function TOpViewData.getNewForm: TForm;
begin
 result:= TFrmOpViewData.CreateFromOperator(self); 
end;

{ TOpPrmViewData }

function TOpPrmViewData.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmViewData.CreateFromOpPrm(self);
end;

procedure TOpPrmViewData.GetParameters;
begin
 inherited GetParameters(prmModif);
 //ici, pas de modif de paramtres invalidant la suite
 prmModif:= FALSE;
end;

procedure TOpPrmViewData.SetDefaultParameters;
begin
 FViewStatus:= asAll;
end;

initialization
 RegisterClass(TMLGenCompViewData);
end.
