(*******************************************************************)
(* UDlgDatasetDownload.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Chargement de l'ensemble de donnes aprs vrifications)
@author(Ricco)
@created(12/01/2004)
Demande le nom du fichier puis se connecte et charge les donnes si tout est ok
}
unit UDlgDatasetDownload;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBase, StdCtrls, ExtCtrls, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomBrowseEdit,
  LMDFileOpenEdit, ComCtrls,
  UCompDefinition, UDatasetDefinition,
  UDataAccessDefinition,
  LMDCustomComponent, LMDCustomHint,
  LMDCustomShapeHint, LMDMessageHint,
  LMDFileSaveEdit;

type
  {Bote de dialogue de chargement du fichier}      
  TDlgDatasetDownload = class(TDlgBase)
    Label1: TLabel;
    FileOpenEdit: TLMDFileOpenEdit;
    Label2: TLabel;
    edTitle: TEdit;
    progression: TProgressBar;
    TimerProgression: TTimer;
    msgHint: TLMDMessageHint;
    DiagramSaveEdit: TLMDFileSaveEdit;
    Label3: TLabel;
    procedure btnOkClick(Sender: TObject);
    procedure TimerProgressionTimer(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    {pointeur sur le diagramme}
    FDiag: TMLDiagram;
    {pointeur sur l'ensemble de donnes}
    FLstAtt: TLstAttributes;
    {le lecteur de fichier}
    FReader: TAccessAbstract;
    {tester si les infos ncssaires  la sauvegarde sont ok}
    function    isOkSaveDiagram(): Boolean; 
    {tester si les infos ncessaires au chargement sont ok}
    function    isReadyToDownload(): boolean;
    {commencer le chargement}
    procedure   startDownload();
    {la procdure proprement dite de chargement}
    procedure   coreDownload(prmThread: TThread);
    {fin du chargement}
    procedure   endDownload(Sender: TObject);
  public
    {Le thread de chargement}
    Thread: TThread;
    {Indique si le chargement a t interrompu ou a t complet}
    FCompleteDownload: Boolean;
    {construire la bote et pointer sur les bonnes infos}
    constructor CreateFromDiagram(prmDiag: TMLDiagram; prmLstAtt: TLstAttributes);
    {fait appatre la bote et lance le chargement}
    function    getDataset(): boolean;
  end;

  {le thread qui s'occupe du chargement de donnes}
  TThreadDownload = class(TThread)
                      private
                      FDlg: TDlgDatasetDownload;
                      function    GetTerminated(): Boolean;
                      public
                      constructor Create(dlg: TDlgDatasetDownload);
                      procedure   Execute; override;
                      property    isTerminated: Boolean read GetTerminated;
                     end;

var
  DlgDatasetDownload: TDlgDatasetDownload;

implementation

uses
        ULogFile,
        UDataAccessTextFile, UDataAccessWEKAFile;

{$R *.dfm}

{ TDlgDatasetDownload }

constructor TDlgDatasetDownload.CreateFromDiagram(prmDiag: TMLDiagram;
  prmLstAtt: TLstAttributes);
var def_dgm: string;
begin
 inherited Create(nil);
 FDiag:= prmDiag;
 FLstAtt:= prmLstAtt;
 Thread:= NIL;
 //nom du diagramme par dfaut
 def_dgm:= GetCurrentDir();
 if (def_dgm[length(def_dgm)]<>'\')
  then def_dgm:= def_dgm+'\';
 def_dgm:= def_dgm+'default.bdm';
 DiagramSaveEdit.Filename:= def_dgm;
end;

function TDlgDatasetDownload.getDataset: boolean;
begin
 //blocage de l'excution jusqu' la fermeture, on peut ainsi attendre
 result:= (ShowModal = mrOk);
end;

function TDlgDatasetDownload.isReadyToDownload: boolean;
begin
 //tester si le fichier est spcifi et qu'il existe
 if (self.FileOpenEdit.Filename<>'') and FileExists(self.FileOpenEdit.Filename)
  then result:= true
  else result:= false;
end;

procedure TDlgDatasetDownload.btnOkClick(Sender: TObject);
begin
 if self.isOkSaveDiagram
  then
   begin
     if self.isReadyToDownload
      then self.startDownload()
      else self.msgHint.ShowControlMessage('Bad file reference',self.FileOpenEdit);
   end
  else self.msgHint.ShowControlMessage('Bad file reference',self.DiagramSaveEdit);
end;

procedure TDlgDatasetDownload.startDownload;
var th: TThreadDownload;
begin
 //invalider le bouton ok
 self.btnOk.Enabled:= FALSE;
 //lancer le thread qui charge les donnes
 th:= TThreadDownload.Create(self);
 th.FreeOnTerminate:= TRUE;
 th.OnTerminate:= endDownload;
 th.Resume;
 //ok timer
 self.TimerProgression.Enabled:= TRUE;
 TraceLog.WriteToLogFile('TDlgDatasetDownload.startDownload');
end;

procedure TDlgDatasetDownload.coreDownload(prmThread: TThread);
var tps: cardinal;
begin

 FReader:= FDiag.getInstanceReaderFile(self.FileOpenEdit.Filename,FLstAtt);

 tps:= GetTickCount();
 TraceLog.WriteToLogFile('TDlgDatasetDownload.coreDownload - dbut importation');

 if FReader.Connecting(self.FileOpenEdit.Filename)
  then FReader.Download(prmThread);

 tps:= GetTickCount()-tps;
 TraceLog.WriteToLogFile('TDlgDatasetDownload.coreDownload - fin importation ::: dure '+IntToStr(tps)+' ms.');

 //rcuprer les infos pour affichage
 FDiag.HTMLAccessInfos.recupInfosHTML(FReader.getLstInfosHTML());

 FReader.Free;
 FReader:= nil;

 //chargement a t normal ou interrompu ?
 FCompleteDownload:= not((prmThread as TThreadDownload).isTerminated);
end;

procedure TDlgDatasetDownload.endDownload(Sender: TObject);
begin
 //dconnecter le timer
 self.TimerProgression.Enabled:= FALSE;
 TraceLog.WriteToLogFile('TDlgDatasetDownload.endDownload >> '+IntToStr(FLstAtt.Size)+' examples and '+IntToStr(FLstAtt.Count)+' attributes');
 //fermer la bote de dialogue avec la bonne info
 //17/07/03 on va la jouer fine
 //!!! mme si l'excution a t interrompue, on garde quand mme ce qui a t charg !!!
 //du coup, toujours ok
 modalResult:= mrOk;
 (*
 if FCompleteDownload
  then modalResult:= mrOk
  else modalResult:= mrCancel;
 *)
end;

procedure TDlgDatasetDownload.TimerProgressionTimer(Sender: TObject);
begin
 if assigned(FReader)
  then progression.Position:= FReader.GetProgression()
  else self.TimerProgression.Enabled:= false;
end;

function TDlgDatasetDownload.isOkSaveDiagram: Boolean;
var sdgm,spath: string;
    ok: boolean;
begin
 ok:= FALSE;
 //rcuprer le nom du diagramme
 sdgm:= self.DiagramSaveEdit.Filename;
 spath:= extractfilepath(sdgm);
 if DirectoryExists(spath)
  then ok:= true;
 result:= ok;
end;

{ TThreadDownload }

constructor TThreadDownload.Create(dlg: TDlgDatasetDownload);
begin
 inherited Create(true);//pas d'excution immdiate
 FDlg:= dlg;
 dlg.Thread:= self;
end;

procedure TThreadDownload.Execute;
begin
 FDlg.coreDownload(self);
end;

function TThreadDownload.GetTerminated: Boolean;
begin
 result:= self.Terminated;
end;

procedure TDlgDatasetDownload.btnCancelClick(Sender: TObject);
begin
 //stopper le thread en essayant d'tre propre
 if assigned(Thread)
  then Thread.Terminate
  //fonctionnement normal du bouton
  else modalResult:= mrCancel;
end;

end.
