(*************************************************************************)
(* UPaletteGenCompDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************************)

{
@abstract(Objets pour la gestion de la palette de composants)
@author(Ricco)
@created(12/01/2004)
Dfintion de la palette de composant. L'ide est de lister l'ensemble des catgories
de composants. Puis, pour chaque catgorie de prparer les outils pour qu'un gnrateur de composant
puisse prendre place. Ces palettes sont par la suite insres dans la fiche de palette @link(UFrmPaletteGenComponents). 
}
unit UPaletteGenCompDefinition;

interface

USES
        Contnrs,
        ComCtrls, Classes,Controls,Graphics,
        UCompDefinition;

TYPE

        {Un objet gnrateur de composant  insrer dans une feuille de palette}
        TListItemMLComponent = class(TObject)
                               private
                               {l'item dans la listview}
                               FListItem: TListItem;
                               {gnrateur de composant associ  l'objet graphique}
                               FGenComp: TMLGenComp; 
                               public
                               constructor CreateML(AOwner: TListItems;prmGenComp: TMLGenComp);
                               {gnrateur de composant}
                               property    MLGenComp: TMLGenComp read FGenComp;
                               end;


        TPgCtrlMLComponent = class;

        {Une feuille de la palette de composant. Elle correspond 
        une catgorie de composant}
        TTabMLComponent = class(TTabSheet)
                          private
                          FLView: TListView;
                          FPgCtrlMLC: TPgCtrlMLComponent;
                          public
                          {le dernier paramtre dfinit la catgorie associe}
                          constructor CreateML(AOwner: TComponent; prmImages: TImageList; prmMlComp: TENumMLComp);
                          procedure   GetMLGenDescription(Sender: TObject; Item: TListItem; var InfoTip: string);
                          property    LView: TListView read FLView;
                          property    PgCtrlMLComp: TPgCtrlMLComponent read FPgCtrlMLC;
                          end;

        {Le gestionnaire complet de la palette de composants}
        TPgCtrlMLComponent = class(TPageControl)
                             private
                             FImages: TIMageList;
                             protected
                             {insertion des diffrentes feuilles de palettes}
                             procedure   InsertPalettes();
                             public
                             constructor CreateML(AOwner: TComponent; prmImages: TImageList);
                             procedure   AddMLGenComp(prmGenComp: TMLGenComp);
                             end;

        {liste globale des gnrateurs de composants}
        TGlobalListMLGenComp = class(TObject)
                               private
                               {la liste de gnrateurs}
                               FLstGenComp: TObjectList;
                               public
                               constructor Create();
                               destructor  destroy(); override;
                               procedure   addGenComp(prmGenComp: TMLGenComp);
                               //recherche par nom du gnrateur de composant
                               function    getGenComp(prmGenCompName: string): TMLGenComp;
                               //oublied - 30/12/03
                               //function    getGenComp(prmNumIcon: integer): TMLGenComp;
                               end;



var
        globalLstGenComp: TGlobalListMLGenComp;

implementation

USES
        Windows, UConstConfiguration;

{ TListItemMLComponent }

constructor TListItemMLComponent.CreateML(AOwner: TListItems;
  prmGenComp: TMLGenComp);
begin
 inherited Create();
 FGenComp:= prmGenComp;
 //cration de la listitem
 FListItem:= AOwner.Add();
 //les initialisation idoines
 FListItem.ImageIndex:= FGenComp.MLNumIcon;
 FListItem.Caption:= FGenComp.MLCompName;
 FListItem.Data:= self;
end;

{ TTabMLComponent }

constructor TTabMLComponent.createML(AOwner: TComponent; prmImages: TImageList;
  prmMlComp: TENumMLComp);
begin
 inherited Create(AOwner);
 self.Parent:= AOwner as TWinControl;
 //initialisation de la page
 self.FPgCtrlMLC:= AOwner as TPgCtrlMLComponent;//interne
 self.PageControl:= AOwner as TPageControl;//visuellement
 self.TabVisible:= TRUE;
 self.Caption:= STR_MLCOMP[prmMlComp];
 //initialisation de la liste des icnes
 FLView:= TListView.Create(self);
 FLView.Parent:= self;
 FLView.Align:= alClient;
 FLView.IconOptions.AutoArrange:= TRUE;
 FLView.SortType:= stText;
 FLView.Font.Name:= COMP_PALETTE_FONT_NAME;
 FLView.Color:= COMP_PALETTE_BACK_COLOR;
 FLView.Font.Size:= COMP_PALETTE_FONT_SIZE;
 FLView.ReadOnly:= TRUE;
 //les images associes aux composants
 FLView.LargeImages:= prmImages;
 FLView.SmallImages:= prmImages;
 FLView.ViewStyle:= vsList;
 //FLView.IconOptions.WrapText:= TRUE;
 //mode de glisser-dposer automatique
 FLView.DragMode:= dmAutomatic;
 //information sur le composant
 FLView.OnInfoTip:= GetMLGenDescription;
 FLView.ShowHint:= TRUE;
end;

procedure TTabMLComponent.GetMLGenDescription(Sender: TObject;
  Item: TListItem; var InfoTip: string);
var mlGen: TMLGenComp;
begin
 mlGen:= TListItemMLComponent(Item.Data).MLGenComp;
 if assigned(mlGen)
  then InfoTip:= mlGen.MLCompDescription;
end;

{ TPgCtrlMLComponent }

procedure TPgCtrlMLComponent.AddMLGenComp(prmGenComp: TMLGenComp);
var tab: TTabMLComponent;
    num: integer;
begin
 num:= ord(prmGenComp.MLComp);
 //rcuprer la feuille de palette associe
 tab:= self.Pages[num] as TTabMLComponent;
 TListItemMLComponent.CreateML(tab.LView.Items,prmGenComp);
 //ajout dans la liste globale
 globalLstGenComp.addGenComp(prmGenComp);
end;

constructor TPgCtrlMLComponent.CreateML(AOwner: TComponent;
  prmImages: TImageList);
begin
 inherited Create(AOwner);
 //paramtrage
 self.Parent:= AOwner as TWinControl;
 self.Align:= alClient;
 self.Style:= tsFlatButtons;
 self.MultiLine:= TRUE;
 self.TabPosition:= tpTop;
 self.ScrollOpposite:= FALSE;
 self.TabHeight:= COMP_PALETTE_TAB_HEIGHT;
 self.TabWidth:= COMP_PALETTE_TAB_WIDTH;
 self.Font.Name:= COMP_PALETTE_FONT_NAME;
 self.Font.Size:= COMP_PALETTE_FONT_SIZE;
 //les objets associs
 FImages:= prmImages;
 self.insertPalettes();
end;

procedure TPgCtrlMLComponent.InsertPalettes;
var mlComp: TEnumMLComp;
begin
 //cration des onglets pour chaque catgorie de composant
 for mlComp:= low(TEnumMLComp) to high(TEnumMLComp) do
  TTabMLComponent.CreateML(self,FImages,mlComp);
end;

{ TGlobalListMLGenComp }

procedure TGlobalListMLGenComp.addGenComp(prmGenComp: TMLGenComp);
begin
 FLstGenComp.Add(prmGenComp);
end;

constructor TGlobalListMLGenComp.Create;
begin
 inherited Create();
 FLstGenComp:= TObjectList.Create(FALSE);
end;

destructor TGlobalListMLGenComp.destroy;
begin
 FLstGenComp.Free;
 inherited Destroy;
end;

(*
function TGlobalListMLGenComp.getGenComp(prmNumIcon: integer): TMLGenComp;
var i: integer;
    gc: TMLGenComp;
begin
 result:= NIL;
 for i:= 0 to pred(FLstGenComp.Count) do
  begin
   gc:= FLstGenComp.Items[i] as TMLGenComp;
   if (gc.MLNumIcon = prmNumIcon)
    then
     begin
      result:= gc;
      BREAK;
     end;
  end;
end;
*)

function TGlobalListMLGenComp.getGenComp(prmGenCompName: string): TMLGenComp;
var i: integer;
    gc: TMLGenComp;
begin
 result:= NIL;
 for i:= 0 to pred(FLstGenComp.Count) do
  begin
   gc:= FLstGenComp.Items[i] as TMLGenComp;
   if (gc.ClassName = prmGenCompName)
    then
     begin
      result:= gc;
      BREAK;
     end;
  end;
end;

initialization
 globalLstGenComp:= TGlobalListMLGenComp.Create();
finalization
 globalLstGenComp.Free;
end.
