import pandas as pd
import numpy as np
from Orange.data import Table, Domain, ContinuousVariable, StringVariable, DiscreteVariable

#Data <==> données codées 0/1
df_one = pd.DataFrame(in_data.X)

#Récupération des données metas (np.ndarray)
metas = in_data.metas

#Coordonnées des modalités <=> Object
df_coord = pd.DataFrame(in_object)

#mettre en matrices numpy
ind_mat = df_one.to_numpy()
var_mat = df_coord.to_numpy()

#effectuer le produit matriciel
#et ne récupérer que les 2 premières colonnes
ind_coord = np.dot(ind_mat,var_mat)[:,:2]

#création du domaine pour la sortie
domain = Domain(attributes=[ContinuousVariable("Comp_1"),
                            ContinuousVariable("Comp_2")],
                metas=[StringVariable("Chien"),
                       DiscreteVariable("Fonction",values=["chasse","compagnie","utilite"])])

#former la liste des données
data = []
for i in range(ind_mat.shape[0]):
    data.append([ind_coord[i,0],ind_coord[i,1],metas[i,0],metas[i,1]])

#exporter
out_data = Table.from_list(domain,data)