#pour l'analyse discriminante
library(MASS)

#pour mesurer le temps de traitement
library(microbenchmark)

#données iris
data(iris)
str(iris)

#duplication des données iris
set.seed(0)
new_size <- 1000
big_iris <- iris[sample(1:nrow(iris),new_size,replace=TRUE),]
str(big_iris)

#vérif. lda
lda(Species ~ ., data = big_iris)

#leave-one-out - version 1
lvo_v1 <- function(nom_classe, data){
  #vecteur de résultat
  v <- c()
  #boucler
  for (i in 1:nrow(data)){
    #données de test
    DTest <- data[i,]
    #données d'apprentissage
    DTrain <- data[-i,]
    #modélisation - appel de lda avec formule
    formule <- paste(nom_classe,"~ .")
    modele <- lda(as.formula(formule), data=DTrain)
    #prédiction
    pred <- predict(modele, newdata=DTest)
    #récupère la prédiction
    v <- c(v,levels(data[,nom_classe])[pred$class[1]])
  }
  #taux d'erreur
  err_rate <- mean(data[,nom_classe] != v)
  #retourner
  return(err_rate)
}

#vérif.
print(lvo_v1("Species",big_iris))

#temps de traitement
#system.time(lvo_v1("Species",big_iris))

#temps de traitement, plus précis
#microbenchmark(lvo_v1("Species",big_iris),times=3)

#leave-one-out - version 2
lvo_v2 <- function(nom_classe, data){
  #isoler les structures
  y <- data[,nom_classe]
  X <- data[,colnames(data) != nom_classe]
  #vecteur de résultat
  v <- c()
  #boucler
  for (i in 1:nrow(data)){
    #données de test - descripteurs seulement
    XTest <- X[i,]
    #données d'apprentissage
    yTrain <- y[-i]
    XTrain <- X[-i,]
    #modélisation - appel de lda avec grouping
    modele <- lda(x=XTrain,grouping=yTrain, data=DTrain)
    #prédiction
    pred <- predict(modele, newdata=XTest)
    #récupère la prédiction (numéro de classe)
    v <- c(v,pred$class[1])
  }
  #typage de la prédiction à la fin seulement
  v <- levels(data[,nom_classe])[v]
  #taux d'erreur
  err_rate <- mean(y != v)
  #retourner
  return(err_rate)
}

#vérif.
print(lvo_v2("Species",big_iris))

#temps de traitement
#system.time(lvo_v2("Species",big_iris))

#temps de traitement, plus précis
#microbenchmark(lvo_v2("Species",big_iris),times=3)
